/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.commands;

import java.util.List;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.ui.internal.InternalWSDLMultiPageEditor;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Type;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11TopLevelElementCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.edit.WSDLXSDElementReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;
import org.eclipse.wst.xsd.ui.internal.editor.XSDElementReferenceEditManager;
import org.eclipse.xsd.XSDSchema;

public class W11SetElementCommand
extends W11TopLevelElementCommand {
    private Part parent;
    private String action;
    private boolean continueApply;

    public W11SetElementCommand(Part parent, String action) {
        super(Messages._UI_ACTION_SET_ELEMENT, parent.getEnclosingDefinition());
        this.parent = parent;
        this.action = action;
    }

    @Override
    public void execute() {
        try {
            this.beginRecording(this.definition.getElement());
            ComponentReferenceEditManager componentReferenceEditManager = this.getComponentReferenceEditManager();
            this.continueApply = true;
            if (this.action.equals("SetTypeAction_AddType")) {
                ComponentSpecification newValue = (ComponentSpecification)this.invokeDialog(componentReferenceEditManager.getNewDialog());
                if (this.continueApply) {
                    componentReferenceEditManager.modifyComponentReference((Object)this.parent, newValue);
                }
            } else {
                ComponentSpecification newValue = (ComponentSpecification)this.invokeDialog(componentReferenceEditManager.getBrowseDialog());
                if (this.continueApply) {
                    componentReferenceEditManager.modifyComponentReference((Object)this.parent, newValue);
                }
            }
            this.formatChild(this.parent.getElement());
        }
        finally {
            this.endRecording(this.definition.getElement());
        }
    }

    private Object invokeDialog(IComponentDialog dialog) {
        ComponentSpecification newValue = null;
        if (dialog == null) {
            return null;
        }
        if (dialog.createAndOpen() == 0) {
            newValue = dialog.getSelectedComponent();
        } else {
            this.continueApply = false;
        }
        return newValue;
    }

    protected ComponentReferenceEditManager getComponentReferenceEditManager() {
        ComponentReferenceEditManager result = null;
        IEditorPart editor = ASDEditorPlugin.getActiveEditor();
        if (editor != null) {
            result = (ComponentReferenceEditManager)editor.getAdapter(XSDElementReferenceEditManager.class);
            if (editor instanceof InternalWSDLMultiPageEditor) {
                InternalWSDLMultiPageEditor wsdlEditor = (InternalWSDLMultiPageEditor)editor;
                List types = wsdlEditor.getModel().getTypes();
                XSDSchema[] schemas = new XSDSchema[types.size()];
                int index = 0;
                while (index < types.size()) {
                    W11Type type = (W11Type)types.get(index);
                    schemas[index] = (XSDSchema)type.getTarget();
                    ++index;
                }
                ((WSDLXSDElementReferenceEditManager)result).setSchemas(schemas);
                return result;
            }
        }
        return result;
    }
}

