/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.util;

import java.util.concurrent.atomic.AtomicReference;

public class LazyConstructable<T> {
    private final AtomicReference<Result<T>> resultRef;

    public static <T> LazyConstructable<T> create(Factory<T> factory) {
        return new LazyConstructable<T>(factory);
    }

    public LazyConstructable(Factory<T> factory) {
        this.resultRef = new AtomicReference<FutureResult>(new FutureResult(factory));
    }

    public T get() {
        return this.resultRef.get().get();
    }

    public static interface Factory<T> {
        public T construct();
    }

    private class FutureResult
    extends Result<T> {
        private final Factory<T> factory;

        private FutureResult(Factory<T> factory) {
            this.factory = factory;
        }

        @Override
        T get() {
            Object newResult = this.factory.construct();
            LazyConstructable.this.resultRef.compareAndSet(this, new ReadyResult(newResult));
            return ((Result)LazyConstructable.this.resultRef.get()).get();
        }
    }

    private static class ReadyResult<T>
    extends Result<T> {
        private final T result;

        public ReadyResult(T result) {
            this.result = result;
        }

        @Override
        T get() {
            return this.result;
        }
    }

    private static abstract class Result<T> {
        private Result() {
        }

        abstract T get();
    }
}

