/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.SelectionBasedAction;

class FileBasedAction {
    FileBasedAction() {
    }

    private static <RES> List<RES> readFilesFromSelectionObject(Object element, FileFilter<RES> fileFilter) {
        if (!(element instanceof ResourceMapping)) {
            return null;
        }
        ResourceMapping resourceMapping = (ResourceMapping)element;
        return FileBasedAction.readFiles(resourceMapping, fileFilter);
    }

    private static <RES> List<RES> readFiles(ResourceMapping resourceMapping, final FileFilter<RES> fileFilter) {
        final ArrayList fileList = new ArrayList(1);
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (!(resource instanceof IFile)) {
                    return true;
                }
                IFile file = (IFile)resource;
                Object res = fileFilter.accept(file);
                if (res != null) {
                    fileList.add(res);
                }
                return false;
            }
        };
        try {
            IProject project = resourceMapping.getProjects()[0];
            if (project.isOpen()) {
                resourceMapping.accept(null, visitor, null);
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return fileList;
    }

    static abstract class FileFilter<T> {
        FileFilter() {
        }

        abstract T accept(IFile var1);
    }

    static abstract class Multiple<RES>
    extends SelectionBasedAction.Multiple<RES> {
        private final FileFilter<RES> fileFilter;

        protected Multiple(FileFilter<RES> fileFilter) {
            this.fileFilter = fileFilter;
        }

        @Override
        protected List<? extends RES> readSelection(IStructuredSelection selection) {
            ArrayList files = new ArrayList(1);
            for (Object element : selection) {
                files.addAll(FileBasedAction.readFilesFromSelectionObject(element, this.fileFilter));
            }
            return files;
        }
    }

    static abstract class Single<RES>
    extends SelectionBasedAction.Single<RES> {
        private final FileFilter<RES> fileFilter;

        protected Single(boolean allowMutipleSelection, FileFilter<RES> fileFilter) {
            super(allowMutipleSelection);
            this.fileFilter = fileFilter;
        }

        @Override
        protected RES castElement(Object element) {
            List files = FileBasedAction.readFilesFromSelectionObject(element, this.fileFilter);
            if (files.size() != 1) {
                return null;
            }
            return (RES)files.get(0);
        }
    }
}

