/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.search;

import java.util.Calendar;
import java.util.StringTokenizer;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.validator.RegexValidator;

public class DateValidator
extends RegexValidator {
    private static final String DATE_REGEX = "\\d{1,2}/\\d{1,2}/\\d{4}";

    public DateValidator() {
        super(1, DATE_REGEX);
        this.setMessageText("RegexValidator_Information_MissingValue", Messages.DateValidator_InfoPrompt);
        this.setMessageText("RegexValidator_Error_InvalidValue", Messages.DateValidator_InfoFormat);
    }

    public boolean isValid(String newText) {
        boolean valid = super.isValid(newText);
        if (valid) {
            try {
                DateValidator.parseTimeInMillis(newText);
                return true;
            }
            catch (IllegalArgumentException e) {
                String error = e.getMessage();
                this.setMessage(error, 3);
            }
        }
        return false;
    }

    public static long parseTimeInMillis(String newText) throws IllegalArgumentException {
        StringTokenizer tokenizer = new StringTokenizer(newText, "/");
        String month_str = tokenizer.nextToken();
        int month = 0;
        try {
            month = Integer.parseInt(month_str);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(Messages.DateValidator_MonthInvalidNumber);
        }
        if (month <= 0 || month > 12) {
            throw new IllegalArgumentException(Messages.DateValidator_MonthOutofRange);
        }
        String date_str = tokenizer.nextToken();
        int date = 0;
        try {
            date = Integer.parseInt(date_str);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(Messages.DateValidator_DateInvalidNumber);
        }
        if (date <= 0 || date > 31) {
            throw new IllegalArgumentException(Messages.DateValidator_DateOutofRange);
        }
        String year_str = tokenizer.nextToken();
        int year = 0;
        try {
            year = Integer.parseInt(year_str);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(Messages.DateValidator_YearInvalidNumber);
        }
        if (year <= 0) {
            throw new IllegalArgumentException(Messages.DateValidator_YearOutofRange);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.set(year, month - 1, date);
        try {
            return calendar.getTimeInMillis();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Messages.DateValidator_InvalidDate);
        }
    }
}

