/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.rse.ui.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.rse.ui.view.System;
import org.eclipse.reddeer.eclipse.rse.ui.wizards.newconnection.RSEMainNewConnectionWizard;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;

public class SystemViewPart
extends WorkbenchView {
    public static final String TITLE = "Remote Systems";
    private static final Logger log = Logger.getLogger(SystemViewPart.class);

    public SystemViewPart() {
        super(TITLE);
    }

    public RSEMainNewConnectionWizard newConnection() {
        log.info("Creating new connection");
        this.activate();
        this.getSystem("Local").select();
        new ContextMenuItem(new String[]{"New", "Connection..."}).select();
        new DefaultShell("New Connection");
        return new RSEMainNewConnectionWizard();
    }

    public List<System> getSystems() {
        Tree tree;
        ArrayList<System> systems = new ArrayList<System>();
        try {
            tree = this.getSystemTree();
        }
        catch (CoreLayerException coreLayerException) {
            return new ArrayList<System>();
        }
        for (TreeItem item : tree.getItems()) {
            systems.add(this.createSystem(item));
        }
        return systems;
    }

    public System getSystem(String name) {
        for (System system : this.getSystems()) {
            if (!system.getLabel().equals(name)) continue;
            return system;
        }
        throw new EclipseLayerException("There is no remote system with name " + name);
    }

    protected Tree getSystemTree() {
        this.activate();
        return new DefaultTree((ReferencedComposite)this.cTabItem);
    }

    protected System createSystem(TreeItem item) {
        return new System(item);
    }
}

