/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.model;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ptp.internal.ui.model.ElementSet;
import org.eclipse.ptp.internal.ui.model.IElementHandler;
import org.eclipse.ptp.internal.ui.model.IElementSet;

public class ElementHandler
implements IElementHandler {
    private final BitSet fRegisteredElements = new BitSet();
    private final Map<String, IElementSet> fSets = new HashMap<String, IElementSet>();

    public ElementHandler() {
        this.fSets.put("Root", new ElementSet("Root", "Root"));
    }

    @Override
    public IElementSet createSet(String id, String name, BitSet elements) {
        IElementSet set = this.fSets.get(id);
        if (set == null) {
            set = new ElementSet(id, name);
            set.addElements(elements);
            this.fSets.put(id, set);
        }
        return set;
    }

    @Override
    public BitSet getRegistered() {
        return (BitSet)this.fRegisteredElements.clone();
    }

    @Override
    public IElementSet getSet(String id) {
        return this.fSets.get(id);
    }

    @Override
    public IElementSet[] getSets() {
        return this.fSets.values().toArray(new IElementSet[0]);
    }

    @Override
    public IElementSet[] getSetsContaining(int element) {
        ArrayList<IElementSet> sets = new ArrayList<IElementSet>();
        for (IElementSet set : this.fSets.values()) {
            if (!set.contains(element)) continue;
            sets.add(set);
        }
        return sets.toArray(new IElementSet[0]);
    }

    @Override
    public boolean isRegistered(int index) {
        return this.fRegisteredElements.get(index);
    }

    @Override
    public void register(BitSet elements) {
        this.fRegisteredElements.or(elements);
    }

    @Override
    public void removeAllRegistered() {
        this.fRegisteredElements.clear();
    }

    @Override
    public IElementSet removeSet(String id) {
        return this.fSets.remove(id);
    }

    @Override
    public int size() {
        return this.fSets.size();
    }

    @Override
    public int totalRegistered() {
        return this.fRegisteredElements.size();
    }

    @Override
    public void unRegister(BitSet elements) {
        this.fRegisteredElements.andNot(elements);
    }
}

