/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.ui;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.internal.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.internal.rdt.sync.ui.handlers.CommonSyncExceptionHandler;
import org.eclipse.ptp.internal.rdt.sync.ui.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.SyncFlag;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.handlers.ISyncExceptionHandler;
import org.eclipse.ptp.rdt.sync.core.resources.RemoteSyncNature;

public class ResourceChangeListener {
    static int DELTA_OPS_TO_SYNC = 2390272;
    private static IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 4) {
                IProject project = (IProject)event.getResource();
                if (!RemoteSyncNature.hasNature((IProject)project)) {
                    return;
                }
                SyncManager.setSyncMode((IProject)project, (SyncManager.SyncMode)SyncManager.SyncMode.UNAVAILABLE);
                String currentSyncServiceId = SyncConfigManager.getActive((IProject)project).getSyncProviderId();
                try {
                    SyncManager.getSyncService((String)currentSyncServiceId).close(project);
                }
                catch (CoreException e) {
                    RDTSyncUIPlugin.log(e);
                }
                return;
            }
            if (!SyncManager.getSyncAuto()) {
                return;
            }
            IResourceDeltaVisitor deltaVisitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    SyncConfig syncConfig;
                    IProject project = delta.getResource().getProject();
                    if (project == null || delta.getAffectedChildren().length > 0) {
                        return true;
                    }
                    if (!RemoteSyncNature.hasNature((IProject)project)) {
                        return false;
                    }
                    int kind = delta.getKind();
                    int flags = delta.getFlags();
                    if (((kind & 3) != 0 || (kind & 4) != 0 && (flags & DELTA_OPS_TO_SYNC) != 0) && (syncConfig = SyncConfigManager.getActive((IProject)project)) != null && syncConfig.isSyncOnSave()) {
                        SyncManager.SyncMode syncMode = SyncManager.getSyncMode((IProject)project);
                        try {
                            if (syncMode == SyncManager.SyncMode.ALL) {
                                SyncManager.syncAll((IResourceDelta)delta, (IProject)project, (Set)SyncFlag.LR_ONLY, (ISyncExceptionHandler)new CommonSyncExceptionHandler(true, false));
                            } else if (syncMode == SyncManager.SyncMode.ACTIVE) {
                                SyncManager.sync((IResourceDelta)delta, (IProject)project, (Set)SyncFlag.LR_ONLY, (ISyncExceptionHandler)new CommonSyncExceptionHandler(true, false));
                            }
                        }
                        catch (CoreException e) {
                            RDTSyncUIPlugin.log(Messages.ResourceChangeListener_0, e);
                        }
                    }
                    return true;
                }
            };
            try {
                event.getDelta().accept(deltaVisitor);
            }
            catch (CoreException e) {
                RDTSyncUIPlugin.log(Messages.ResourceChangeListener_1, e);
            }
        }
    };

    private ResourceChangeListener() {
    }

    public static void startListening() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(resourceListener, 5);
    }

    public static void stopListening() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(resourceListener);
    }
}

