/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.aif;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFormatException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFType;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeUnion;
import org.eclipse.ptp.internal.debug.core.pdi.aif.AIFType;
import org.eclipse.ptp.internal.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.internal.debug.core.pdi.model.aif.AIFFactory;

public class AIFTypeUnion
extends AIFType
implements IAIFTypeUnion {
    private final List<AIFField> fFields = new ArrayList<AIFField>();
    private String fName = "";
    private int fSize = 0;

    @Override
    public String[] getFieldNames() {
        String[] names = new String[this.fFields.size()];
        int i = 0;
        while (i < this.fFields.size()) {
            names[i] = this.fFields.get((int)i).name;
            ++i;
        }
        return names;
    }

    @Override
    public IAIFType[] getFieldTypes() {
        IAIFType[] types = new IAIFType[this.fFields.size()];
        int i = 0;
        while (i < this.fFields.size()) {
            types[i] = this.fFields.get((int)i).type;
            ++i;
        }
        return types;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public int sizeof() {
        return this.fSize;
    }

    public String toString() {
        String content = String.valueOf(String.valueOf('(')) + this.getName() + '|';
        int i = 0;
        while (i < this.fFields.size()) {
            if (i > 0) {
                content = String.valueOf(content) + ',';
            }
            AIFField field = this.fFields.get(i);
            content = String.valueOf(content) + field.name + '=' + field.type.toString();
            ++i;
        }
        return String.valueOf(content) + ')';
    }

    @Override
    public String parse(String fmt) throws AIFFormatException {
        fmt = this.parseName(fmt);
        while (fmt.length() > 0 && fmt.charAt(0) != ')') {
            if ((fmt = this.parseField(fmt)).charAt(0) != ',') continue;
            fmt = fmt.substring(1);
        }
        if (fmt.charAt(0) != ')') {
            throw new AIFFormatException(Messages.AIFTypeUnion_0);
        }
        return fmt.substring(1);
    }

    private String parseField(String fmt) throws AIFFormatException {
        AIFField field = new AIFField();
        int pos = fmt.indexOf(61);
        if (pos == -1) {
            throw new AIFFormatException(Messages.AIFTypeUnion_1);
        }
        field.name = fmt.substring(0, pos);
        fmt = fmt.substring(pos + 1);
        fmt = AIFFactory.parseType(fmt);
        IAIFType aifType = AIFFactory.getType();
        this.fSize += aifType.sizeof();
        field.type = aifType;
        this.fFields.add(field);
        return fmt;
    }

    private String parseName(String fmt) throws AIFFormatException {
        int pos = fmt.indexOf(124);
        if (pos == -1) {
            throw new AIFFormatException(Messages.AIFTypeUnion_2);
        }
        this.fName = fmt.substring(0, pos);
        return fmt.substring(pos + 1);
    }

    private class AIFField {
        public String name;
        public IAIFType type;

        private AIFField() {
        }
    }
}

