/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceReference;

public class FullyQualifiedReference
extends TypeReference {
    public static final int T_TYPE = 1;
    public static final int T_FUNCTION = 2;
    public static final int T_CONSTANT = 3;
    private NamespaceReference namespace;
    private boolean nullable;
    private int elementType;

    public FullyQualifiedReference(int start, int end, String name, NamespaceReference namespace) {
        this(start, end, name, namespace, 3);
    }

    public FullyQualifiedReference(int start, int end, String name, NamespaceReference namespace, int type) {
        super(start, end, name);
        this.namespace = namespace;
        this.elementType = type;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Expression)this)) {
            if (this.namespace != null) {
                this.namespace.traverse(pVisitor);
            }
            pVisitor.endvisit((Expression)this);
        }
    }

    @Nullable
    public NamespaceReference getNamespace() {
        return this.namespace;
    }

    public void setNamespace(NamespaceReference namespace) {
        this.namespace = namespace;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public String getFullyQualifiedName() {
        if (this.namespace == null) {
            return this.getName();
        }
        String name = this.namespace.getName();
        StringBuilder buf = new StringBuilder(name);
        if (name.length() == 0 || name.charAt(name.length() - 1) != '\\') {
            buf.append('\\');
        }
        buf.append(this.getName());
        return buf.toString();
    }

    public int getElementType() {
        return this.elementType;
    }

    public void setElementType(int elementType) {
        this.elementType = elementType;
    }
}

