/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import org.eclipse.photran.internal.core.util.Messages;

public final class Spawner {
    public static boolean SHOW_OUTPUT_ON_ERROR = true;

    private Spawner() {
    }

    public static String run(String ... args) throws Exception {
        return Spawner.run(null, Arrays.asList(args));
    }

    public static String run(List<String> args) throws Exception {
        return Spawner.run(null, args);
    }

    public static String run(File workingDirectory, String ... args) throws Exception {
        return Spawner.run(workingDirectory, Arrays.asList(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String run(File workingDirectory, List<String> args) throws Exception {
        ConcurrentReader output;
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.directory(workingDirectory);
        builder.redirectErrorStream(true);
        Process process = builder.start();
        ConcurrentReader concurrentReader = output = new ConcurrentReader(process.getInputStream());
        synchronized (concurrentReader) {
            output.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                if (SHOW_OUTPUT_ON_ERROR) {
                    System.err.println(output.toString());
                }
                throw new Exception(Messages.bind((String)Messages.Spawner_ProcessExitedAbnormally, (Object)exitCode, (Object)output.toString()));
            }
            Spawner.waitFor(output);
        }
        return output.toString();
    }

    private static void waitFor(ConcurrentReader output) {
        try {
            output.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class ConcurrentReader
    extends Thread {
        private InputStream stdout;
        private StringBuilder sb;

        public ConcurrentReader(InputStream stdout) {
            this.stdout = stdout;
            this.sb = new StringBuilder();
        }

        @Override
        public void run() {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.stdout));
            try {
                try {
                    String line = in.readLine();
                    while (line != null) {
                        this.sb.append(line);
                        this.sb.append('\n');
                        line = in.readLine();
                    }
                    this.done();
                }
                catch (IOException e) {
                    this.sb.append(e.toString());
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        this.sb.append(e2.toString());
                    }
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.sb.append(e.toString());
                }
            }
        }

        private synchronized void done() {
            this.notifyAll();
        }

        @Override
        public String toString() {
            return this.sb.toString();
        }
    }
}

