/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import java.util.LinkedList;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageLifeCycleEventsListener;

public class ActivePageHistoryTracker
implements IPageLifeCycleEventsListener {
    private LinkedList<IPage> history = new LinkedList();

    @Override
    public void pageChanged(IPage newPage) {
        System.out.println("pageChanged - " + newPage.getPageTitle());
    }

    @Override
    public void pageOpened(IPage page) {
        this.history.add(page);
    }

    @Override
    public void pageClosed(IPage page) {
        this.history.remove(page);
    }

    @Override
    public void pageActivated(IPage page) {
        this.history.remove(page);
        this.history.push(page);
    }

    @Override
    public void pageDeactivated(IPage page) {
    }

    @Override
    public void pageAboutToBeOpened(IPage page) {
    }

    @Override
    public void pageAboutToBeClosed(IPage page) {
    }

    public IPage lastActivePage() {
        return this.history.peekFirst();
    }
}

