/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.ui.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ocl.examples.debug.vm.core.VMLineBreakpoint;
import org.eclipse.ocl.examples.debug.vm.ui.actions.AbstractVMBreakpointPropertiesHandler;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.handlers.HandlerUtil;

public class VMBreakpointPropertiesHandler
extends AbstractVMBreakpointPropertiesHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        assert (event != null);
        VMLineBreakpoint breakpoint = this.getBreakpoint(event);
        if (breakpoint == null) {
            return null;
        }
        IWorkbenchSite shellProvider = HandlerUtil.getActiveSite((ExecutionEvent)event);
        if (shellProvider == null) {
            return this.popUpError(event, "No IShellProvider", null);
        }
        BreakpointSelectionProvider breakpointSelectionProvider = new BreakpointSelectionProvider(breakpoint);
        PropertyDialogAction propertyAction = new PropertyDialogAction((IShellProvider)shellProvider, (ISelectionProvider)breakpointSelectionProvider);
        propertyAction.run();
        return null;
    }

    protected static class BreakpointSelectionProvider
    implements ISelectionProvider {
        private final @NonNull VMLineBreakpoint breakpoint;

        protected BreakpointSelectionProvider(@NonNull VMLineBreakpoint breakpoint) {
            this.breakpoint = breakpoint;
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return new StructuredSelection((Object)this.breakpoint);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }
}

