/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.spi.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.reviews.ui.ReviewsImages;
import org.eclipse.mylyn.reviews.core.model.IApprovalType;
import org.eclipse.mylyn.reviews.core.model.IChange;
import org.eclipse.mylyn.reviews.core.model.IRequirementEntry;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewerEntry;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.reviews.core.model.RequirementStatus;
import org.eclipse.mylyn.reviews.ui.spi.editor.AbstractReviewSection;
import org.eclipse.mylyn.reviews.ui.spi.editor.Messages;
import org.eclipse.mylyn.reviews.ui.spi.factories.AbstractUiFactoryProvider;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class ReviewDetailSection
extends AbstractReviewSection {
    public ReviewDetailSection() {
        this.setPartName(Messages.ReviewDetailSection_Review);
    }

    @Override
    protected Control createContent(FormToolkit toolkit, Composite parent) {
        Control content = super.createContent(toolkit, parent);
        this.createReviewersSubSection(this.composite);
        this.createDependenciesSubSection(toolkit, this.composite, Messages.ReviewDetailSection_Depends_On, this.getReview().getParents());
        this.createDependenciesSubSection(toolkit, this.composite, Messages.ReviewDetailSection_Needed_By, this.getReview().getChildren());
        return content;
    }

    protected void createReviewersSubSection(Composite parent) {
        if (this.getReview().getReviewerApprovals().isEmpty() && !this.canAddReviewers()) {
            return;
        }
        int style = 8274;
        Section subSection = this.toolkit.createSection(parent, style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)subSection);
        subSection.setTitleBarForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        subSection.setText(Messages.ReviewDetailSection_Reviewers);
        Composite composite = this.toolkit.createComposite((Composite)subSection);
        List approvalTypes = this.getModelRepository().getApprovalTypes();
        ArrayList<IApprovalType> approvalTypesWithLabel = new ArrayList<IApprovalType>(approvalTypes.size());
        for (IApprovalType approvalType : approvalTypes) {
            if (approvalType.getName().equals(approvalType.getKey())) continue;
            approvalTypesWithLabel.add(approvalType);
        }
        int numColumns = approvalTypesWithLabel.size() + 1;
        GridLayoutFactory.fillDefaults().numColumns(numColumns).extendedMargins(0, 0, 0, 5).equalWidth(true).spacing(4, 5).applyTo(composite);
        subSection.setClient((Control)composite);
        if (!approvalTypesWithLabel.isEmpty()) {
            StringBuilder names = new StringBuilder();
            Label headerLabel = new Label(composite, 0);
            headerLabel.setText(" ");
            StringBuilder needs = new StringBuilder();
            for (IApprovalType approvalType : approvalTypesWithLabel) {
                IRequirementEntry requirementEntry = (IRequirementEntry)this.getReview().getRequirements().get(approvalType);
                Composite headerContainer = new Composite(composite, 0);
                headerContainer.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG"));
                GridLayoutFactory.fillDefaults().numColumns(2).applyTo(headerContainer);
                GridDataFactory.fillDefaults().align(0x1000000, 4).applyTo((Control)headerContainer);
                CLabel approvalHeaderLabel = new CLabel(headerContainer, 0);
                approvalHeaderLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                approvalHeaderLabel.setText(approvalType.getName());
                GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)approvalHeaderLabel);
                RequirementStatus status = null;
                if (requirementEntry != null) {
                    status = requirementEntry.getStatus();
                    switch (status) {
                        case SATISFIED: {
                            approvalHeaderLabel.setImage(CommonImages.getImage((ImageDescriptor)ReviewsImages.APPROVED));
                            break;
                        }
                        case NOT_SATISFIED: {
                            approvalHeaderLabel.setImage(CommonImages.getImage((ImageDescriptor)ReviewsImages.UNKNOWN));
                            break;
                        }
                        case REJECTED: {
                            approvalHeaderLabel.setImage(CommonImages.getImage((ImageDescriptor)ReviewsImages.REJECTED));
                            break;
                        }
                        default: {
                            approvalHeaderLabel.setImage(CommonImages.getImage((ImageDescriptor)ReviewsImages.BLANK));
                        }
                    }
                }
                if (status == null || status != RequirementStatus.UNKNOWN && status != RequirementStatus.REJECTED) continue;
                if (needs.length() > 0) {
                    needs.append(", ");
                }
                needs.append(approvalType.getName());
            }
            AbstractUiFactoryProvider<IUser> reviewerUiFactoryProvider = this.getReviewerUiFactoryProvider();
            TreeMap sortedReviewerApprovals = new TreeMap((u1, u2) -> u1.getDisplayName().compareTo(u2.getDisplayName()));
            sortedReviewerApprovals.putAll(this.getReview().getReviewerApprovals());
            for (Map.Entry approval : sortedReviewerApprovals.entrySet()) {
                IUser currentUser = (IUser)approval.getKey();
                this.createReviewerLabelAndControls(composite, reviewerUiFactoryProvider, currentUser);
                for (IApprovalType approvalType : approvalTypesWithLabel) {
                    Integer value = (Integer)((IReviewerEntry)approval.getValue()).getApprovals().get(approvalType);
                    Label approvalValueLabel = new Label(composite, 0);
                    GridDataFactory.fillDefaults().align(0x1000000, 4).applyTo((Control)approvalValueLabel);
                    String rankingText = " ";
                    if (value != null && value != 0) {
                        if (value > 0) {
                            rankingText = String.valueOf(rankingText) + "+";
                            approvalValueLabel.setForeground(Display.getCurrent().getSystemColor(6));
                        } else if (value < 0) {
                            approvalValueLabel.setForeground(Display.getCurrent().getSystemColor(3));
                        }
                        rankingText = String.valueOf(rankingText) + value;
                        approvalValueLabel.setToolTipText(value + "  " + approvalType.getName());
                    }
                    approvalValueLabel.setText(rankingText);
                }
                if (names.length() > 0) {
                    names.append(", ");
                }
                names.append(currentUser.getDisplayName());
            }
            String headerText = names.toString();
            if (needs.length() > 0) {
                headerText = String.valueOf(headerText) + NLS.bind((String)Messages.ReviewDetailSection_Needs_X, (Object)needs);
            }
            if (headerText.length() > 0) {
                this.addTextClient(this.toolkit, subSection, headerText);
            }
        }
        if (this.getUiFactoryProvider() != null) {
            Composite actionComposite = this.getUiFactoryProvider().createControls(this, composite, this.getToolkit(), this.getReview());
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)actionComposite);
        }
    }

    private void createReviewerLabelAndControls(Composite parent, AbstractUiFactoryProvider<IUser> reviewerUiFactoryProvider, IUser user) {
        Composite reviewerComp = this.toolkit.createComposite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(reviewerComp);
        if (reviewerUiFactoryProvider != null) {
            this.createReviewerControls(reviewerComp, user, reviewerUiFactoryProvider);
        }
        this.createReviewerLabel(reviewerComp, user);
    }

    private void createReviewerLabel(Composite reviewerComposite, IUser user) {
        Label reviewerRowLabel = new Label(reviewerComposite, 0);
        reviewerRowLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        reviewerRowLabel.setText(user.getDisplayName());
    }

    private void createReviewerControls(Composite reviewerComposite, IUser user, AbstractUiFactoryProvider<IUser> reviewerUiFactoryProvider) {
        Composite controlComposite = reviewerUiFactoryProvider.createControls(this, reviewerComposite, this.getToolkit(), user);
        GridDataFactory.fillDefaults().applyTo((Control)controlComposite);
    }

    protected boolean canAddReviewers() {
        return true;
    }

    protected void createDependenciesSubSection(FormToolkit toolkit, Composite parent, String title, List<IChange> changes) {
        if (changes.isEmpty()) {
            return;
        }
        int style = 18;
        Section subSection = toolkit.createSection(parent, style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)subSection);
        subSection.setTitleBarForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        subSection.setText(title);
        Composite composite = toolkit.createComposite((Composite)subSection);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 5).applyTo(composite);
        subSection.setClient((Control)composite);
        for (final IChange change : changes) {
            Link link = new Link(composite, 0);
            String changeStatus = change.getState() != null ? NLS.bind((String)Messages.ReviewDetailSection_Bracket_X_bracket, (Object)String.valueOf(change.getState().getName())) : " ";
            String ownerName = change.getOwner().getDisplayName();
            link.setText(NLS.bind((String)Messages.ReviewDetailSection_Link_W_X_Y_by_Z, (Object[])new String[]{StringUtils.left((String)change.getKey(), (int)9), change.getSubject(), changeStatus, ownerName}));
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TasksUiUtil.openTask((TaskRepository)ReviewDetailSection.this.getTaskEditorPage().getTaskRepository(), (String)change.getId());
                }
            });
        }
    }

    protected abstract AbstractUiFactoryProvider<IReview> getUiFactoryProvider();

    protected AbstractUiFactoryProvider<IUser> getReviewerUiFactoryProvider() {
        return null;
    }

    protected boolean shouldExpandOnCreate() {
        return true;
    }
}

