/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui;

import org.eclipse.egit.github.core.Repository;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.internal.github.core.issue.IssueConnector;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestConnector;
import org.eclipse.mylyn.internal.github.ui.CredentialsWizardPage;
import org.eclipse.mylyn.internal.github.ui.RepositorySelectionWizardPage;
import org.eclipse.mylyn.internal.github.ui.gist.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchImages;

public class TaskRepositoryImportWizard
extends Wizard
implements IImportWizard {
    private CredentialsWizardPage credentialsPage;
    private RepositorySelectionWizardPage reposPage;

    public TaskRepositoryImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_WIZBAN_IMPORT_WIZ"));
        this.setWindowTitle(org.eclipse.mylyn.internal.github.ui.Messages.TaskRepositoryImportWizard_Title);
    }

    public void addPages() {
        this.credentialsPage = new CredentialsWizardPage();
        this.addPage((IWizardPage)this.credentialsPage);
        this.reposPage = new RepositorySelectionWizardPage();
        this.addPage((IWizardPage)this.reposPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage next = super.getNextPage(page);
        if (next == this.reposPage) {
            this.reposPage.setUser(this.credentialsPage.getUserName());
            this.reposPage.setPassword(this.credentialsPage.getPassword());
            this.reposPage.setIsToken(this.credentialsPage.isToken());
        }
        return next;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        String user = this.credentialsPage.getUserName();
        String password = this.credentialsPage.getPassword();
        boolean isToken = this.credentialsPage.isToken();
        IRepositoryManager manager = TasksUi.getRepositoryManager();
        Repository[] repositoryArray = this.reposPage.getRepositories();
        int n = repositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Repository repo = repositoryArray[n2];
            manager.addRepository(IssueConnector.createTaskRepository((Repository)repo, (String)user, (String)password, (boolean)isToken));
            manager.addRepository(PullRequestConnector.createTaskRepository((Repository)repo, (String)user, (String)password, (boolean)isToken));
            ++n2;
        }
        if (this.reposPage.createGistRepository()) {
            AuthenticationCredentials credentials = new AuthenticationCredentials(user, password);
            TaskRepository repository = new TaskRepository("githubGists", "https://gist.github.com");
            repository.setRepositoryLabel(Messages.GistRepositorySettingsPage_RepositoryLabelDefault);
            repository.setCredentials(AuthenticationType.REPOSITORY, credentials, true);
            repository.setCategory("org.eclipse.mylyn.category.review");
            repository.setProperty(GitHub.PROPERTY_USE_TOKEN, Boolean.toString(isToken));
            manager.addRepository(repository);
        }
        return true;
    }
}

