/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui.editor.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.internal.rpm.ui.editor.parser.SpecfileTag;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileSection;

public class SpecfilePackage
extends SpecfileSection {
    private String description;
    private List<SpecfileSection> sections;
    private List<SpecfileTag> requires;
    private String packageName;
    private String summary;
    private String group;

    public SpecfilePackage(String packageName, Specfile specfile) {
        super("package", specfile);
        super.setSpecfile(specfile);
        this.setPackageName(packageName);
        this.setPackage(this);
        this.sections = new ArrayList<SpecfileSection>();
        this.requires = new ArrayList<SpecfileTag>();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return this.getPackageName();
    }

    public void addSection(SpecfileSection section) {
        this.sections.add(section);
    }

    public SpecfileSection[] getSections() {
        SpecfileSection[] toReturn = new SpecfileSection[this.sections.size()];
        return this.sections.toArray(toReturn);
    }

    public boolean hasChildren() {
        return this.sections != null && this.sections.size() > 0;
    }

    @Override
    public SpecfilePackage getPackage() {
        return this;
    }

    @Override
    public String getPackageName() {
        return this.resolve(this.packageName);
    }

    public String getFullPackageName() {
        if (this.getSpecfile().getName().equals(this.getPackageName())) {
            return this.getPackageName();
        }
        return String.valueOf(this.getSpecfile().getName()) + "-" + this.getPackageName();
    }

    public final void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isMainPackage() {
        return this.getSpecfile().getName().equals(this.getPackageName());
    }

    public void addRequire(SpecfileTag require) {
        this.requires.add(require);
    }

    public List<SpecfileTag> getRequires() {
        return this.requires;
    }
}

