/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.ui.newwizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.libra.warproducts.ui.Messages;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.PDEWizardNewFileCreationPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class WARProductFileWizardPage
extends PDEWizardNewFileCreationPage {
    public static final int USE_DEFAULT = 0;
    public static final int USE_LAUNCH_CONFIG = 1;
    private static final String FILE_EXTENSION = "warproduct";
    private Button basicButton;
    private Button launchConfigButton;
    private Combo launchConfigCombo;
    private Group group;

    public WARProductFileWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.setDescription(Messages.FileWizardPageNewFile);
        this.setTitle(Messages.FileWizardPageTitle);
        this.setFileExtension(FILE_EXTENSION);
    }

    protected void createAdvancedControls(Composite parent) {
        this.group = new Group(parent, 0);
        this.group.setText(Messages.FileWizardPageInit);
        this.group.setLayout((Layout)new GridLayout(2, false));
        this.group.setLayoutData((Object)new GridData(768));
        this.basicButton = new Button((Composite)this.group, 16);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.basicButton.setLayoutData((Object)gd);
        this.basicButton.setText(Messages.FileWizardPageCreate);
        this.launchConfigButton = new Button((Composite)this.group, 16);
        String buttonText = Messages.FileWizardPageLaunchConfig;
        this.launchConfigButton.setText(buttonText);
        this.launchConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WARProductFileWizardPage.this.launchConfigCombo.setEnabled(WARProductFileWizardPage.this.launchConfigButton.getSelection());
            }
        });
        this.launchConfigCombo = new Combo((Composite)this.group, 12);
        this.launchConfigCombo.setLayoutData((Object)new GridData(768));
        this.launchConfigCombo.setItems(this.getLaunchConfigurations());
        this.initializeState();
    }

    private void initializeState() {
        this.launchConfigCombo.setEnabled(false);
        if (this.launchConfigCombo.getItemCount() > 0) {
            this.launchConfigCombo.setText(this.launchConfigCombo.getItem(0));
        }
        this.basicButton.setSelection(true);
    }

    private String[] getLaunchConfigurations() {
        ArrayList list = new ArrayList();
        try {
            String eclipseConf = "org.eclipse.pde.ui.RuntimeWorkbench";
            this.addLaunchConfigToListFromType(list, eclipseConf);
            String osgiConf = "org.eclipse.pde.ui.EquinoxLauncher";
            this.addLaunchConfigToListFromType(list, osgiConf);
            String rapConf = "org.eclipse.rap.ui.launch.RAPLauncher";
            this.addLaunchConfigToListFromType(list, rapConf);
        }
        catch (CoreException e) {
            PDEPlugin.logException((Throwable)e);
        }
        String[] launchConfigArray = new String[list.size()];
        return list.toArray(launchConfigArray);
    }

    private void addLaunchConfigToListFromType(List list, String type) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = manager.getLaunchConfigurationType(type);
        ILaunchConfiguration[] configs = manager.getLaunchConfigurations(configType);
        int i = 0;
        while (i < configs.length) {
            if (!DebugUITools.isPrivate((ILaunchConfiguration)configs[i])) {
                list.add(configs[i].getName());
            }
            ++i;
        }
    }

    public ILaunchConfiguration getSelectedLaunchConfiguration() {
        ILaunchConfiguration result = null;
        if (this.launchConfigButton.getSelection()) {
            String configName = this.launchConfigCombo.getText();
            try {
                ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                String eclipseConf = "org.eclipse.pde.ui.RuntimeWorkbench";
                ILaunchConfigurationType type = manager.getLaunchConfigurationType(eclipseConf);
                String osgiConf = "org.eclipse.pde.ui.EquinoxLauncher";
                ILaunchConfigurationType type2 = manager.getLaunchConfigurationType(osgiConf);
                String rapCong = "org.eclipse.rap.ui.launch.RAPLauncher";
                ILaunchConfigurationType type3 = manager.getLaunchConfigurationType(rapCong);
                ILaunchConfiguration[] configs = manager.getLaunchConfigurations(type);
                ILaunchConfiguration[] configs2 = manager.getLaunchConfigurations(type2);
                ILaunchConfiguration[] configs3 = manager.getLaunchConfigurations(type3);
                ILaunchConfiguration[] configurations = new ILaunchConfiguration[configs.length + configs2.length + configs3.length];
                System.arraycopy(configs, 0, configurations, 0, configs.length);
                System.arraycopy(configs2, 0, configurations, configs.length, configs2.length);
                System.arraycopy(configs3, 0, configurations, configs2.length, configs3.length);
                int i = 0;
                while (i < configurations.length && result == null) {
                    if (configurations[i].getName().equals(configName) && !DebugUITools.isPrivate((ILaunchConfiguration)configurations[i])) {
                        result = configurations[i];
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException((Throwable)e);
            }
        }
        return result;
    }

    public int getInitializationOption() {
        int result = 1;
        if (this.basicButton.getSelection()) {
            result = 0;
        }
        return result;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Dialog.applyDialogFont((Control)this.group);
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        String contextId = "org.eclipse.libra.warproducts.help.warproduct_new_wizard_filepage";
        helpSystem.setHelp(this.getControl(), contextId);
    }

    protected boolean validatePage() {
        boolean valid = super.validatePage();
        if (valid) {
            IPath containerPath = this.getContainerFullPath();
            valid = this.validateWarProductLocation(valid, containerPath);
        }
        return valid;
    }

    private boolean validateWarProductLocation(boolean valid, IPath containerPath) {
        boolean result = valid;
        IContainer container = this.getSelectedContainer(containerPath);
        try {
            IResource[] members = container.members();
            int i = 0;
            while (i < members.length && valid) {
                IResource member = members[i];
                String extension = member.getFileExtension();
                if (extension != null && extension.equals(FILE_EXTENSION)) {
                    result = false;
                    this.setErrorMessage(Messages.FileWizardPageError);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)PDEUIMessages.ProductExportWizard_error, (String)e.getMessage());
        }
        return result;
    }

    private IContainer getSelectedContainer(IPath containerPath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Object container = containerPath.segmentCount() > 1 ? root.getFolder(containerPath) : root.getProject(containerPath.toOSString());
        return container;
    }
}

