/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.resources;

import java.util.regex.Pattern;
import org.eclipse.jst.jsf.designtime.internal.resources.LibraryResourceFragmentIdentifier;
import org.eclipse.jst.jsf.designtime.internal.resources.LibraryResourceIdentifier;
import org.eclipse.jst.jsf.designtime.internal.resources.ResourceFragmentIdentifier;
import org.eclipse.jst.jsf.designtime.internal.resources.ResourceIdentifier;

public class ResourceIdentifierFactory {
    public static final String VersionRegex = "[0-9]+(_[0-9]+)*";
    public static final Pattern VersionPattern = Pattern.compile("[0-9]+(_[0-9]+)*");

    public ResourceIdentifier createLibraryResource(String idString) throws InvalidIdentifierException {
        String[] parts = idString.split("/");
        String resName = null;
        String libraryName = null;
        switch (parts.length) {
            case 1: {
                resName = parts[0];
                break;
            }
            case 2: {
                resName = parts[1];
                libraryName = parts[0];
                break;
            }
            case 3: {
                if (VersionPattern.matcher(parts[1]).matches()) {
                    resName = parts[2];
                    libraryName = parts[0];
                    break;
                }
                throw new InvalidIdentifierException(idString);
            }
            case 4: {
                if (VersionPattern.matcher(parts[2]).matches()) {
                    resName = parts[3];
                    libraryName = parts[1];
                    break;
                }
                if (VersionPattern.matcher(parts[1]).matches()) {
                    resName = parts[2];
                    libraryName = parts[0];
                    break;
                }
                resName = parts[2];
                libraryName = parts[1];
                break;
            }
            case 5: {
                resName = parts[3];
                libraryName = parts[1];
            }
        }
        if (resName == null) {
            throw new InvalidIdentifierException(idString);
        }
        return new LibraryResourceIdentifier(resName, libraryName);
    }

    public ResourceFragmentIdentifier createLibraryFragment(String libraryName) {
        return new LibraryResourceFragmentIdentifier(libraryName);
    }

    public static class InvalidIdentifierException
    extends Exception {
        private final String _id;
        private static final long serialVersionUID = -8926293207447823901L;

        public InvalidIdentifierException(String id) {
            this._id = id;
        }

        public InvalidIdentifierException(String message, Throwable cause, String id) {
            super(message, cause);
            this._id = id;
        }

        public InvalidIdentifierException(String message, String id) {
            super(message);
            this._id = id;
        }

        public InvalidIdentifierException(Throwable cause, String id) {
            super(cause);
            this._id = id;
        }

        public final String getId() {
            return this._id;
        }
    }
}

