/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lfs.lib.LongObjectId;
import org.eclipse.jgit.util.IO;

public class LfsPointer
implements Comparable<LfsPointer> {
    public static final String VERSION = "https://git-lfs.github.com/spec/v1";
    public static final String VERSION_LEGACY = "https://hawser.github.com/spec/v1";
    public static final int SIZE_THRESHOLD = 200;
    public static final String HASH_FUNCTION_NAME = "SHA-256".toLowerCase(Locale.ROOT).replace("-", "");
    static final int FULL_SIZE_THRESHOLD = 8192;
    private final AnyLongObjectId oid;
    private final long size;

    public LfsPointer(AnyLongObjectId oid, long size) {
        this.oid = oid;
        this.size = size;
    }

    public AnyLongObjectId getOid() {
        return this.oid;
    }

    public long getSize() {
        return this.size;
    }

    public void encode(OutputStream out) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PrintStream ps = new PrintStream(out, false, StandardCharsets.UTF_8.name());){
                ps.print("version ");
                ps.print("https://git-lfs.github.com/spec/v1\n");
                ps.print("oid " + HASH_FUNCTION_NAME + ":");
                ps.print(String.valueOf(this.oid.name()) + "\n");
                ps.print("size ");
                ps.print(String.valueOf(this.size) + "\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Nullable
    public static LfsPointer parseLfsPointer(InputStream in) throws IOException {
        if (in.markSupported()) {
            return LfsPointer.parse(in);
        }
        return LfsPointer.parse(new BufferedInputStream(in));
    }

    @Nullable
    private static LfsPointer parse(InputStream in) throws IOException {
        if (!in.markSupported()) {
            throw new IllegalArgumentException("LFS pointer parsing needs InputStream.markSupported() == true");
        }
        in.mark(200);
        byte[] preamble = new byte[200];
        int length = IO.readFully((InputStream)in, (byte[])preamble, (int)0);
        if (length < preamble.length || in.read() < 0) {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(preamble, 0, length), StandardCharsets.UTF_8));){
                LfsPointer ptr = LfsPointer.parse(r);
                if (ptr == null) {
                    in.reset();
                }
                return ptr;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        boolean hasVersion = LfsPointer.checkVersion(preamble);
        in.reset();
        if (!hasVersion) {
            return null;
        }
        in.mark(8192);
        byte[] fullPointer = new byte[8192];
        length = IO.readFully((InputStream)in, (byte[])fullPointer, (int)0);
        if (length == fullPointer.length && in.read() >= 0) {
            in.reset();
            return null;
        }
        Throwable throwable = null;
        Object var6_13 = null;
        try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(fullPointer, 0, length), StandardCharsets.UTF_8));){
            LfsPointer ptr = LfsPointer.parse(r);
            if (ptr == null) {
                in.reset();
            }
            return ptr;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static LfsPointer parse(BufferedReader r) throws IOException {
        boolean versionLine = false;
        LongObjectId id = null;
        long sz = -1L;
        String s = r.readLine();
        while (s != null) {
            if (!s.startsWith("#") && s.length() != 0) {
                block13: {
                    if (s.startsWith("version")) {
                        if (versionLine || !LfsPointer.checkVersionLine(s)) {
                            return null;
                        }
                        versionLine = true;
                    } else {
                        try {
                            if (s.startsWith("oid sha256:")) {
                                if (id != null) {
                                    return null;
                                }
                                id = LongObjectId.fromString(s.substring(11).trim());
                                break block13;
                            }
                            if (s.startsWith("size")) {
                                if (sz > 0L || s.length() < 5 || s.charAt(4) != ' ') {
                                    return null;
                                }
                                sz = Long.parseLong(s.substring(5).trim());
                            }
                        }
                        catch (RuntimeException e) {
                            if (versionLine) {
                                throw e;
                            }
                            return null;
                        }
                    }
                }
                if (versionLine && id != null && sz > -1L) {
                    return new LfsPointer(id, sz);
                }
            }
            s = r.readLine();
        }
        return null;
    }

    private static boolean checkVersion(byte[] data) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(data), StandardCharsets.UTF_8));){
                String s = r.readLine();
                if (s != null && s.startsWith("version")) {
                    return LfsPointer.checkVersionLine(s);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static boolean checkVersionLine(String s) {
        if (s.length() < 8 || s.charAt(7) != ' ') {
            return false;
        }
        String rest = s.substring(8).trim();
        return VERSION.equals(rest) || VERSION_LEGACY.equals(rest);
    }

    public String toString() {
        return "LfsPointer: oid=" + this.oid.name() + ", size=" + this.size;
    }

    @Override
    public int compareTo(LfsPointer o) {
        int x = this.getOid().compareTo(o.getOid());
        if (x != 0) {
            return x;
        }
        return Long.compare(this.getSize(), o.getSize());
    }

    public int hashCode() {
        return Objects.hash(this.getOid()) * 31 + Long.hashCode(this.getSize());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LfsPointer other = (LfsPointer)obj;
        return Objects.equals(this.getOid(), other.getOid()) && this.getSize() == other.getSize();
    }
}

