/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.ui.container;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtext.ui.containers.JavaProjectsState;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperJdtExtensions;

@Singleton
public class XcoreJavaProjectsState
extends JavaProjectsState {
    @Inject
    IStorage2UriMapperJdtExtensions jdtExtensions;

    protected String doInitHandle(URI uri) {
        String result = this.getJavaProjectsHelper().initHandle(uri);
        if (result == null && uri.isPlatformResource() && uri.segmentCount() > 1) {
            IProject project = this.getWorkspaceRoot().getProject(URI.decode((String)uri.segment(1)));
            IJavaProject javaProject = JavaCore.create((IProject)project);
            result = javaProject.exists() ? javaProject.getHandleIdentifier() : project.getName();
        }
        return result;
    }

    protected List<String> doInitVisibleHandles(String handle) {
        IJavaElement javaElement;
        List result = this.getJavaProjectsHelper().initVisibleHandles(handle);
        if (!result.isEmpty() && (javaElement = JavaCore.create((String)handle)) != null) {
            if (!(result = new UniqueEList((Collection)result)).contains(handle)) {
                result.add(0, handle);
            }
            ListIterator<String> i = result.listIterator();
            block0: while (i.hasNext()) {
                String projectHandle;
                String visibleHandle = (String)i.next();
                IJavaElement visibleHandleElement = JavaCore.create((String)visibleHandle);
                if (!(visibleHandleElement instanceof IPackageFragmentRoot)) continue;
                IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)visibleHandleElement;
                Map allEntries = this.jdtExtensions.getAllEntries(packageFragmentRoot);
                for (URI uri : allEntries.keySet()) {
                    if (!"xcore".equals(uri.fileExtension()) || !uri.isPlatformResource()) continue;
                    String uriHandle = this.initHandle(uri);
                    if (result.contains(uriHandle)) continue block0;
                    i.add(uriHandle);
                    continue block0;
                }
                IJavaProject javaProject = packageFragmentRoot.getJavaProject();
                if (javaProject == null || result.contains(projectHandle = javaProject.getHandleIdentifier())) continue;
                i.add(projectHandle);
            }
            IProject project = javaElement.getJavaProject().getProject();
            result.addAll(this.getProjectsHelper().initVisibleHandles(project.getName()));
        }
        return result;
    }
}

