/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

public class RemoteMessageRequest
extends CDOClientRequest<Set<Integer>> {
    private CDORemoteSessionMessage message;
    private List<CDORemoteSession> recipients;

    public RemoteMessageRequest(CDOClientProtocol protocol, CDORemoteSessionMessage message, List<CDORemoteSession> recipients) {
        super(protocol, (short)29);
        this.message = message;
        this.recipients = recipients;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        this.message.write((ExtendedDataOutput)out);
        out.writeXInt(this.recipients.size());
        for (CDORemoteSession recipient : this.recipients) {
            out.writeXInt(recipient.getSessionID());
        }
    }

    @Override
    protected Set<Integer> confirming(CDODataInput in) throws IOException {
        HashSet<Integer> sessionIDs = new HashSet<Integer>();
        int count = in.readXInt();
        int i = 0;
        while (i < count) {
            int sessionID = in.readXInt();
            sessionIDs.add(sessionID);
            ++i;
        }
        return sessionIDs;
    }
}

