/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.rules.CActivityValidator;

public class CompensateScopeValidator
extends CActivityValidator {
    protected INode fOwnerScopeProcess = null;
    protected String fTargetScopeNCName = null;
    protected INode fTargetScope = null;

    @ARule(date="10/5/2006", author="michal.chmielewski@oracle.com", desc="Check compensateScope placement.", sa=7, errors="BPELC_COMPENSATE__NOT_IN_HANDLER")
    public void rule_CheckPlacement_10() {
        INode parent = this.mNode.parentNode();
        while (parent != null) {
            QName nodeName = parent.nodeName();
            if (ND_COMPENSATION_HANDLER.equals(nodeName) || ND_TERMINATION_HANDLER.equals(nodeName) || ND_CATCH_ALL.equals(nodeName) || ND_CATCH.equals(nodeName)) {
                this.fOwnerScopeProcess = mSelector.selectParent(parent, Filters.SCOPE_OR_PROCESS);
                return;
            }
            parent = parent.parentNode();
        }
        IProblem problem = this.createError();
        problem.fill("BPELC_COMPENSATE__NOT_IN_HANDLER", this.toString(this.mNode.nodeName()), this.ncName);
    }

    @ARule(sa=1004, desc="Check target scope NCName", author="michal.chmielewski@oracle.com", date="02/27/2007", errors="BPELC__UNSET_ATTRIBUTE,General.NCName_Bad")
    public void rule_CheckTargetScopeNCName_15() {
        this.fTargetScopeNCName = this.mNode.getAttribute(AT_TARGET);
        if (!this.checkNCName(this.mNode, this.fTargetScopeNCName, AT_TARGET)) {
            this.disableRules();
        }
    }

    @ARule(sa=77, desc="Make sure that the target scope exists", author="michal.chmielewski@oracle.com", date="02/27/2007", tag="pass2", errors="BPELC_COMPENSATE_SCOPE__NO_TARGET")
    public void rule_CheckTargetScope_25() {
        if (this.isUndefined(this.fOwnerScopeProcess)) {
            return;
        }
        this.fTargetScope = this.getValue(this.fOwnerScopeProcess, "immediate.scope.name." + this.fTargetScopeNCName, null);
        if (this.isUndefined(this.fTargetScope)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_COMPENSATE_SCOPE__NO_TARGET", this.toString(this.mNode.nodeName()), this.mNode.getAttribute(AT_NAME), this.fTargetScopeNCName);
            return;
        }
        QName targetNodeName = this.fTargetScope.nodeName();
        if (!targetNodeName.equals(ND_SCOPE) && !targetNodeName.equals(ND_INVOKE)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_COMPENSATE_SCOPE__NO_TARGET", this.toString(this.mNode.nodeName()), this.mNode.getAttribute(AT_NAME), this.fTargetScopeNCName);
            return;
        }
    }

    @ARule(sa=78, desc="Target of compenateScope must have a fault or compensation handler", author="michal.chmielewski@oracle.com", date="02/27/2007", tag="pass2", errors="BPELC_COMPENSATE_SCOPE__TARGET_NO_HANDLERS")
    public void rule_CheckTargetScopeHandlers_27() {
        if (this.isUndefined(this.fTargetScope)) {
            return;
        }
        int compensationHandlers = this.getValue(this.fTargetScope, ND_COMPENSATION_HANDLER + ".count", 0);
        int faultHandlers = this.getValue(this.fTargetScope, ND_FAULT_HANDLERS + ".count", 0);
        if (faultHandlers < 1 && compensationHandlers < 1) {
            IProblem problem = this.createError();
            problem.fill("BPELC_COMPENSATE_SCOPE__TARGET_NO_HANDLERS", this.toString(this.mNode.nodeName()), this.mNode.getAttribute(AT_NAME), this.fTargetScopeNCName, this.toString(this.fTargetScope.nodeName()));
        }
    }
}

