/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator;

import org.eclipse.bpel.validator.Activator;
import org.eclipse.bpel.validator.Builder;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class Validator
implements IValidator {
    boolean bDebug = true;
    int mechanism = 1;
    Builder fBuilder = new Builder();
    IAdapterManager fAdapterManager = Platform.getAdapterManager();

    public Validator() {
        this.fBuilder.bDebug = this.bDebug;
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        reporter.removeAllMessages((IValidator)this);
        String[] s = helper.getURIs();
        if (s.length < 1) {
            return;
        }
        String[] stringArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            this.p("Starting validation of " + f);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(f);
            if (resource == null || resource.getType() != 1) {
                this.p("File " + f + " does not exist and cannot be validated.");
            } else {
                this.fBuilder.clearCach();
                if (this.mechanism == 1) {
                    this.p("Using mechanism 1: Calling Builder");
                    try {
                        this.fBuilder.validate(resource, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException ce) {
                        Activator.log((Exception)((Object)ce));
                    }
                } else if (this.mechanism == 2) {
                    IProblem[] problems;
                    this.p("Using mechanism 2: Using reporter and message");
                    IProblem[] iProblemArray = problems = this.fBuilder.validate((IFile)resource, (IProgressMonitor)new NullProgressMonitor());
                    int n3 = problems.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IProblem p = iProblemArray[n4];
                        IMessage msg = (IMessage)this.fAdapterManager.getAdapter((Object)p, IMessage.class);
                        if (msg != null) {
                            reporter.addMessage((IValidator)this, msg);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    void p(String msg) {
        if (this.bDebug) {
            System.out.printf("[%1$s]>> %2$s\n", this.getClass().getName(), msg);
            System.out.flush();
        }
    }
}

