/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core.internal.parser;

import org.eclipse.wst.sse.core.internal.ltk.parser.BlockTokenizer;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.xml.core.internal.parser.XMLSourceParser;

public class XSLSourceParser
extends XMLSourceParser {
    public RegionParser newInstance() {
        XSLSourceParser newInstance = new XSLSourceParser();
        newInstance.setTokenizer(this.getTokenizer().newInstance());
        return newInstance;
    }

    protected void setTokenizer(BlockTokenizer newTokenizer) {
        super.setTokenizer(newTokenizer);
    }

    protected IStructuredDocumentRegion parseNodes() {
        IStructuredDocumentRegion headNode = null;
        IStructuredDocumentRegion lastNode = null;
        ITextRegion region = null;
        IStructuredDocumentRegion currentNode = null;
        String type = null;
        while ((region = this.getNextRegion()) != null) {
            type = region.getType();
            if (type == "BLOCK_TEXT") {
                if (currentNode != null && currentNode.getLastRegion().getType() == "BLOCK_TEXT") {
                    currentNode.addRegion(region);
                    currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                    region.adjustStart(-currentNode.getStart());
                } else {
                    if (currentNode != null) {
                        if (!currentNode.isEnded()) {
                            currentNode.setLength(region.getStart() - currentNode.getStart());
                        }
                        lastNode = currentNode;
                    }
                    this.fireNodeParsed(currentNode);
                    currentNode = this.createStructuredDocumentRegion(type);
                    if (lastNode != null) {
                        lastNode.setNext(currentNode);
                    }
                    currentNode.setPrevious(lastNode);
                    currentNode.setStart(region.getStart());
                    currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                    currentNode.setEnded(true);
                    region.adjustStart(-currentNode.getStart());
                    currentNode.addRegion(region);
                }
            } else if (currentNode != null && currentNode.isEnded() || type == "XML_CONTENT" || type == "XML_CHAR_REFERENCE" || type == "XML_ENTITY_REFERENCE" || type == "XML_PI_OPEN" || type == "XML_TAG_OPEN" || type == "XML_END_TAG_OPEN" || type == "XML_COMMENT_OPEN" || type == "XML_CDATA_OPEN" || type == "XML_DECLARATION_OPEN") {
                if (currentNode != null) {
                    if (!currentNode.isEnded()) {
                        currentNode.setLength(region.getStart() - currentNode.getStart());
                    }
                    lastNode = currentNode;
                }
                this.fireNodeParsed(currentNode);
                currentNode = this.createStructuredDocumentRegion(type);
                if (lastNode != null) {
                    lastNode.setNext(currentNode);
                }
                currentNode.setPrevious(lastNode);
                currentNode.setStart(region.getStart());
                currentNode.addRegion(region);
                currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                region.adjustStart(-currentNode.getStart());
            } else if (type == "XML_TAG_NAME" || type == "XML_TAG_ATTRIBUTE_NAME" || type == "XML_TAG_ATTRIBUTE_EQUALS" || type == "XML_TAG_ATTRIBUTE_VALUE" || type == "XML_COMMENT_TEXT" || type == "XML_PI_CONTENT" || type == "XML_DOCTYPE_INTERNAL_SUBSET") {
                currentNode.addRegion(region);
                currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                region.adjustStart(-currentNode.getStart());
            } else if (type == "XML_PI_CLOSE" || type == "XML_TAG_CLOSE" || type == "XML_EMPTY_TAG_CLOSE" || type == "XML_COMMENT_CLOSE" || type == "XML_DECLARATION_CLOSE" || type == "XML_CDATA_CLOSE") {
                currentNode.setEnded(true);
                currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                currentNode.addRegion(region);
                region.adjustStart(-currentNode.getStart());
            } else if (type == "WHITE_SPACE") {
                ITextRegion lastRegion = currentNode.getLastRegion();
                if (lastRegion instanceof ITextRegionContainer) {
                    ITextRegionContainer container = (ITextRegionContainer)lastRegion;
                    container.getRegions().add(region);
                    container.setParent((ITextRegionCollection)currentNode);
                    region.adjustStart(container.getLength() - region.getStart());
                }
                currentNode.getLastRegion().adjustLength(region.getLength());
                currentNode.adjustLength(region.getLength());
            } else if (type == "UNDEFINED" && currentNode != null) {
                if (currentNode.getLastRegion() != null && currentNode.getLastRegion().getType() == "UNDEFINED") {
                    currentNode.getLastRegion().adjustLength(region.getLength());
                    currentNode.adjustLength(region.getLength());
                } else {
                    currentNode.addRegion(region);
                    currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                    region.adjustStart(-currentNode.getStart());
                }
            } else {
                if (currentNode == null) {
                    currentNode = this.createStructuredDocumentRegion(type);
                    currentNode.setStart(region.getStart());
                }
                currentNode.addRegion(region);
                currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                region.adjustStart(-currentNode.getStart());
            }
            if (type == "XML_CONTENT" || type == "XML_CHAR_REFERENCE" || type == "XML_ENTITY_REFERENCE") {
                currentNode.setEnded(true);
            }
            if (headNode != null || currentNode == null) continue;
            headNode = currentNode;
        }
        if (currentNode != null) {
            this.fireNodeParsed(currentNode);
            currentNode.setPrevious(lastNode);
        }
        this.primReset();
        return headNode;
    }
}

