/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.runtime;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeType;
import org.eclipse.wst.jsdt.internal.core.Logger;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class JSRuntimeTypeRegistryReader {
    private static final String EXTENSION_NAME = "org.eclipse.wst.jsdt.core.JSRuntimeType";
    private static final String RUNTIME_TYPE = "runtimeType";
    private static final String RUNTIME_TYPE_ID_ATTR = "id";
    private static final String RUNTIME_TYPE_CLASS_ATTR = "class";
    private static Map<String, IJSRuntimeType> runtimeTypesMap = null;

    private static void initRuntimeTypesMap() {
        runtimeTypesMap = new HashMap<String, IJSRuntimeType>();
        IExtensionPoint exp = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_NAME);
        if (exp == null) {
            return;
        }
        IExtension[] iExtensionArray = exp.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement typeConfigElements = iConfigurationElementArray[n4];
                if (typeConfigElements.getName().equals(RUNTIME_TYPE)) {
                    if (typeConfigElements.getAttribute(RUNTIME_TYPE_ID_ATTR) != null) {
                        String id = typeConfigElements.getAttribute(RUNTIME_TYPE_ID_ATTR);
                        if (runtimeTypesMap.containsKey(id)) {
                            Logger.log(2, "Duplicated runtime type with id = " + id);
                        }
                        try {
                            IJSRuntimeType runtimeType = (IJSRuntimeType)typeConfigElements.createExecutableExtension(RUNTIME_TYPE_CLASS_ATTR);
                            runtimeTypesMap.put(id, runtimeType);
                        }
                        catch (Exception e) {
                            Util.log(e, "Error instantiating class " + typeConfigElements.getAttribute(RUNTIME_TYPE_CLASS_ATTR));
                        }
                    }
                } else {
                    Logger.log(2, "Unexpected tag " + typeConfigElements.getName() + ". Expected " + RUNTIME_TYPE + " instead.");
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static Collection<IJSRuntimeType> getJSRuntimeTypes() {
        if (runtimeTypesMap != null) {
            return runtimeTypesMap.values();
        }
        JSRuntimeTypeRegistryReader.initRuntimeTypesMap();
        return runtimeTypesMap.values();
    }

    public static Collection<String> getJSRuntimeTypesIds() {
        if (runtimeTypesMap != null) {
            return runtimeTypesMap.keySet();
        }
        JSRuntimeTypeRegistryReader.initRuntimeTypesMap();
        return runtimeTypesMap.keySet();
    }

    public static IJSRuntimeType getJSRuntimeType(String typeId) {
        if (runtimeTypesMap == null) {
            JSRuntimeTypeRegistryReader.initRuntimeTypesMap();
        }
        return runtimeTypesMap.get(typeId);
    }
}

