/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api;

import java.util.Objects;
import java.util.Set;
import org.eclipse.viatra.transformation.evm.api.Agenda;
import org.eclipse.viatra.transformation.evm.api.ExecutionSchema;
import org.eclipse.viatra.transformation.evm.api.Executor;
import org.eclipse.viatra.transformation.evm.api.RuleBase;
import org.eclipse.viatra.transformation.evm.api.RuleEngine;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.ScheduledExecution;
import org.eclipse.viatra.transformation.evm.api.Scheduler;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.api.event.EventRealm;

public final class EventDrivenVM {
    private EventDrivenVM() {
    }

    public static RuleEngine createRuleEngine(EventRealm eventRealm) {
        RuleBase ruleBase = new RuleBase(eventRealm, new Agenda());
        return RuleEngine.create(ruleBase);
    }

    public static ExecutionSchema createExecutionSchema(EventRealm eventRealm, Scheduler.ISchedulerFactory schedulerFactory, Set<RuleSpecification<?>> specifications) {
        Objects.requireNonNull(schedulerFactory, "Cannot create execution schema with null scheduler factory");
        Objects.requireNonNull(specifications, "Cannot create execution schema with null rule specification set");
        Executor executor = new Executor();
        RuleBase ruleBase = new RuleBase(eventRealm, new Agenda());
        ScheduledExecution execution = new ScheduledExecution(ruleBase, executor);
        for (RuleSpecification<?> specification : specifications) {
            EventDrivenVM.instantiateRuleInRuleBase(ruleBase, specification);
        }
        Scheduler scheduler = schedulerFactory.prepareScheduler(execution);
        return ExecutionSchema.create(scheduler);
    }

    private static <EventAtom> void instantiateRuleInRuleBase(RuleBase ruleBase, RuleSpecification<EventAtom> specification) {
        EventFilter<EventAtom> emptyFilter = specification.createEmptyFilter();
        ruleBase.instantiateRule(specification, emptyFilter);
    }
}

