/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.data;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Scalar;

public class DataPoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int fStep;
    private Map<Dim, Scalar> fScalars;

    public DataPoint(int step, Map<Dim, Scalar> values) {
        this.fStep = step;
        this.fScalars = values;
    }

    public int getStep() {
        return this.fStep;
    }

    public Dim[] getDimensions() {
        Set<Dim> set = this.fScalars.keySet();
        return set.toArray(new Dim[set.size()]);
    }

    public Collection<Dim> getDimensions2() {
        return this.fScalars.keySet();
    }

    public boolean contains(Dim dimension) {
        return this.fScalars.containsKey(dimension);
    }

    public Scalar[] getScalars() {
        return this.fScalars.values().toArray(new Scalar[this.fScalars.size()]);
    }

    public Scalar getScalar(Dim dimension) {
        return this.fScalars.get(dimension);
    }

    public String toString() {
        return "DataPoint [step= " + this.fStep + ", #dimensions: " + this.fScalars.size() + "]";
    }
}

