/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.support;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.barcharts.BarSeriesSettings;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesSettings;
import org.eclipse.swtchart.extensions.core.AbstractSeriesSettings;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.MappingsType;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.internal.support.SeriesLabelProvider;
import org.eclipse.swtchart.extensions.internal.support.SeriesMapper;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.linecharts.LineSeriesSettings;
import org.eclipse.swtchart.extensions.piecharts.CircularSeriesSettings;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesSettings;
import org.eclipse.swtchart.extensions.scattercharts.IScatterSeriesSettings;
import org.eclipse.swtchart.extensions.scattercharts.ScatterSeriesSettings;

public class MappingsSupport {
    public static void adjustSettings(ScrollableChart scrollableChart) {
        if (scrollableChart != null) {
            ISeries[] seriesArray;
            final BaseChart baseChart = scrollableChart.getBaseChart();
            ISeries[] iSeriesArray = seriesArray = baseChart.getSeriesSet().getSeries();
            int n = seriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeriesSettings seriesSettingsSink;
                ISeries series = iSeriesArray[n2];
                String id = series.getId();
                ISeriesSettings seriesSettingsSource = SeriesMapper.containsMappedSeriesSetting(id) ? SeriesMapper.getSeriesSettingsMapped(id) : SeriesMapper.getSeriesSettingsDefault(id);
                boolean success = MappingsSupport.transferSettings(seriesSettingsSource, seriesSettingsSink = baseChart.getSeriesSettings(id));
                if (success) {
                    baseChart.applySeriesSettings(series, seriesSettingsSink);
                }
                ++n2;
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!baseChart.isDisposed()) {
                        baseChart.redraw();
                    }
                }
            });
        }
    }

    public static void mapSettings(ISeries<?> series, String property, Object object, ScrollableChart scrollableChart) {
        String id = series.getId();
        ISeriesSettings seriesSettingsDefault = SeriesMapper.getSeriesSettingsDefault(id, scrollableChart);
        ISeriesSettings seriesSettings = MappingsSupport.getMappedSettings(id, seriesSettingsDefault);
        boolean mapSetting = scrollableChart != null;
        switch (property) {
            case "Visible": {
                boolean visible = Boolean.parseBoolean(object.toString());
                series.setVisible(visible);
                if (!mapSetting) break;
                seriesSettings.setVisible(visible);
                break;
            }
            case "Visible In Legend": {
                boolean visibleInLegend = Boolean.parseBoolean(object.toString());
                series.setVisibleInLegend(visibleInLegend);
                if (!mapSetting) break;
                seriesSettings.setVisibleInLegend(visibleInLegend);
                break;
            }
            case "Color": {
                if (!(object instanceof RGB)) break;
                RGB rgb = (RGB)object;
                Color color = ResourceSupport.getColor(rgb);
                SeriesLabelProvider.setColor(series, color);
                if (!mapSetting) break;
                MappingsSupport.setColor(seriesSettings, color);
                break;
            }
            case "Description": {
                String description = object.toString().trim();
                series.setDescription(description);
                if (!mapSetting) break;
                seriesSettings.setDescription(description);
                break;
            }
        }
        if (mapSetting) {
            SeriesMapper.mapSetting(id, seriesSettings, seriesSettingsDefault);
        }
    }

    public static boolean transferSettings(ISeriesSettings seriesSettingsSource, ISeriesSettings seriesSettingsSink) {
        boolean success = MappingsSupport.transfer(seriesSettingsSource, seriesSettingsSink);
        if (success) {
            success = MappingsSupport.transfer(seriesSettingsSource.getSeriesSettingsHighlight(), seriesSettingsSink.getSeriesSettingsHighlight());
        }
        return success;
    }

    public static MappingsType getMappingsType(ISeriesSettings seriesSettings) {
        if (seriesSettings instanceof IBarSeriesSettings) {
            return MappingsType.BAR;
        }
        if (seriesSettings instanceof ILineSeriesSettings) {
            return MappingsType.LINE;
        }
        if (seriesSettings instanceof IScatterSeriesSettings) {
            return MappingsType.SCATTER;
        }
        return MappingsType.NONE;
    }

    public static ISeriesSettings copySeriesSettings(ISeriesSettings seriesSettings) {
        if (seriesSettings != null) {
            return seriesSettings.makeDeepCopy();
        }
        return null;
    }

    public static ISeriesSettings createSeriesSettings(MappingsType mappingsType) {
        return MappingsSupport.createSeriesSettings(mappingsType.name());
    }

    public static ISeriesSettings createSeriesSettings(String mappingsTypeName) {
        AbstractSeriesSettings seriesSettings = null;
        try {
            MappingsType mappingsType = MappingsType.valueOf(mappingsTypeName);
            switch (mappingsType) {
                case BAR: {
                    seriesSettings = new BarSeriesSettings();
                    break;
                }
                case LINE: {
                    seriesSettings = new LineSeriesSettings();
                    break;
                }
                case SCATTER: {
                    seriesSettings = new ScatterSeriesSettings();
                    break;
                }
                case CIRCULAR: {
                    seriesSettings = new CircularSeriesSettings();
                    break;
                }
                default: {
                    seriesSettings = null;
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return seriesSettings;
    }

    public static Color getColor(ISeriesSettings seriesSettings) {
        if (seriesSettings instanceof IBarSeriesSettings) {
            IBarSeriesSettings barSeriesSettings = (IBarSeriesSettings)seriesSettings;
            return barSeriesSettings.getBarColor();
        }
        if (seriesSettings instanceof ILineSeriesSettings) {
            ILineSeriesSettings lineSeriesSettings = (ILineSeriesSettings)seriesSettings;
            return lineSeriesSettings.getLineColor();
        }
        if (seriesSettings instanceof ICircularSeriesSettings) {
            ICircularSeriesSettings circularSeriesSettings = (ICircularSeriesSettings)seriesSettings;
            return circularSeriesSettings.getBorderColor();
        }
        return ResourceSupport.getColorDefault();
    }

    public static void setColor(ISeriesSettings seriesSettings, Color color) {
        if (color != null) {
            if (seriesSettings instanceof IBarSeriesSettings) {
                IBarSeriesSettings barSeriesSettings = (IBarSeriesSettings)seriesSettings;
                barSeriesSettings.setBarColor(color);
            } else if (seriesSettings instanceof ILineSeriesSettings) {
                ILineSeriesSettings lineSeriesSettings = (ILineSeriesSettings)seriesSettings;
                lineSeriesSettings.setLineColor(color);
            } else {
                ICircularSeriesSettings circularSeriesSettings = (ICircularSeriesSettings)seriesSettings;
                circularSeriesSettings.setBorderColor(color);
            }
        }
    }

    public static void setEnableArea(ISeriesSettings seriesSettings, boolean enableArea) {
        if (seriesSettings instanceof ILineSeriesSettings) {
            ILineSeriesSettings lineSeriesSettings = (ILineSeriesSettings)seriesSettings;
            lineSeriesSettings.setEnableArea(enableArea);
        }
    }

    private static boolean transfer(ISeriesSettings seriesSettingsSource, ISeriesSettings seriesSettingsSink) {
        boolean success = false;
        if (seriesSettingsSource != null && seriesSettingsSink != null) {
            success = seriesSettingsSource.transfer(seriesSettingsSink);
        }
        return success;
    }

    private static ISeriesSettings getMappedSettings(String id, ISeriesSettings seriesSettingsDefault) {
        ISeriesSettings seriesSettings = SeriesMapper.getSeriesSettingsMapped(id);
        if (seriesSettings == null) {
            seriesSettings = MappingsSupport.copySeriesSettings(seriesSettingsDefault);
        }
        return seriesSettings;
    }
}

