/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.form;

import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scout.sdk.core.apidef.IClassNameSupplier;
import org.eclipse.scout.sdk.core.s.apidef.IScoutAbstractApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutInterfaceApi;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.ui.fields.FieldToolkit;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.internal.form.FormNewWizard;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractCompilationUnitNewWizardPage;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.S2eScoutTier;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;

public class FormNewWizardPage
extends AbstractCompilationUnitNewWizardPage {
    public static final String PROP_CREATE_FORM_DATA = "createFormData";
    public static final String PROP_CREATE_SERVICE = "createService";
    public static final String PROP_CREATE_PERMISSIONS = "createPermissions";
    public static final String PROP_SHARED_SOURCE_FOLDER = "sharedSourceFolder";
    public static final String PROP_SERVER_SOURCE_FOLDER = "serverSourceFolder";
    public static final String PREF_CREATE_FORM_DATA = "createFormData";
    public static final String PREF_CREATE_SERVICE = "createService";
    public static final String PREF_CREATE_PERMISSIONS = "createPermissions";
    protected Button m_createFormDataButton;
    protected Button m_createServiceButton;
    protected Button m_createPermissionsButton;
    protected ProposalTextField m_sharedSourceFolder;
    protected ProposalTextField m_serverSourceFolder;

    public FormNewWizardPage(PackageContainer packageContainer) {
        super(FormNewWizardPage.class.getName(), packageContainer, "Form", ScoutTier.Client);
        this.setTitle("Create a new Form");
        this.setDescription(this.getTitle());
        this.setIcuGroupName("New Form Details");
    }

    @Override
    protected Optional<IClassNameSupplier> calcSuperTypeDefaultFqn() {
        return this.scoutApi().map(IScoutAbstractApi::AbstractForm);
    }

    @Override
    protected Optional<IClassNameSupplier> calcSuperTypeDefaultBaseFqn() {
        return this.scoutApi().map(IScoutInterfaceApi::IForm);
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.initDefaults();
        this.createFormPropertiesGroup(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.scout.sdk.s2e.ui.scout_wizard_form_page_context");
    }

    protected void initDefaults() {
        IDialogSettings settings = this.getDialogSettings();
        String prefCreateFormData = settings.get("createFormData");
        this.setIsCreateFormDataInternal(Strings.isBlank((CharSequence)prefCreateFormData) || Boolean.parseBoolean(prefCreateFormData));
        String prefCreateService = settings.get("createService");
        this.setIsCreateServiceInternal(Strings.isBlank((CharSequence)prefCreateService) || Boolean.parseBoolean(prefCreateService));
        String prefCreatePermissions = settings.get("createPermissions");
        this.setIsCreatePermissionsInternal(Strings.isBlank((CharSequence)prefCreatePermissions) || Boolean.parseBoolean(prefCreatePermissions));
        this.guessSharedAndServerFolders();
    }

    public FormNewWizard getWizard() {
        return (FormNewWizard)super.getWizard();
    }

    @Override
    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        this.getDialogSettings().put("createFormData", Boolean.toString(this.isCreateFormData()));
        this.getDialogSettings().put("createService", Boolean.toString(this.isCreateService()));
        this.getDialogSettings().put("createPermissions", Boolean.toString(this.isCreatePermissions()));
        return true;
    }

    protected void guessSharedAndServerFolders() {
        IPackageFragmentRoot clientSourceFolder = this.getSourceFolder();
        if (!JdtUtils.exists((IJavaElement)clientSourceFolder)) {
            return;
        }
        this.setServerSourceFolder(S2eScoutTier.wrap((ScoutTier)ScoutTier.Client).convert(ScoutTier.Server, clientSourceFolder).orElse(null));
        this.setSharedSourceFolder(S2eScoutTier.wrap((ScoutTier)ScoutTier.Client).convert(ScoutTier.Shared, clientSourceFolder).orElse(null));
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        super.validatePage(multiStatus);
        multiStatus.add(this.getStatusServerSourceFolder());
        multiStatus.add(this.getStatusSharedSourceFolder());
        multiStatus.add(this.getStatusVisibility());
    }

    protected IStatus getStatusVisibility() {
        if (!JdtUtils.exists((IJavaElement)this.getSharedSourceFolder())) {
            return Status.OK_STATUS;
        }
        if (JdtUtils.exists((IJavaElement)this.getServerSourceFolder()) && !this.getServerSourceFolder().getJavaProject().isOnClasspath((IJavaElement)this.getSharedSourceFolder().getJavaProject())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "The Shared Source Folder is not accessible from the selected Server Source Folder.");
        }
        if (JdtUtils.exists((IJavaElement)this.getSourceFolder()) && !this.getSourceFolder().getJavaProject().isOnClasspath((IJavaElement)this.getSharedSourceFolder().getJavaProject())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "The Shared Source Folder is not accessible from the selected Form Source Folder.");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusSharedSourceFolder() {
        if (!(this.isCreateFormData() || this.isCreatePermissions() || this.isCreateService())) {
            return Status.OK_STATUS;
        }
        if (!JdtUtils.exists((IJavaElement)this.getSharedSourceFolder())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please choose a shared source folder.");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusServerSourceFolder() {
        if (this.isCreateService() && !JdtUtils.exists((IJavaElement)this.getServerSourceFolder())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please choose a server source folder.");
        }
        return Status.OK_STATUS;
    }

    @Override
    protected int getLabelWidth() {
        return 130;
    }

    protected void createFormPropertiesGroup(Composite p) {
        Group parent = FieldToolkit.createGroupBox(p, "Additional Components");
        this.m_createFormDataButton = FieldToolkit.createCheckBox((Composite)parent, "Create FormData", this.isCreateFormData());
        this.m_createFormDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormNewWizardPage.this.setIsCreateFormDataInternal(FormNewWizardPage.this.m_createFormDataButton.getSelection());
                FormNewWizardPage.this.handleComponentsChanged();
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_createServiceButton = FieldToolkit.createCheckBox((Composite)parent, "Create Service", this.isCreateService());
        this.m_createServiceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormNewWizardPage.this.setIsCreateServiceInternal(FormNewWizardPage.this.m_createServiceButton.getSelection());
                FormNewWizardPage.this.handleComponentsChanged();
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_createPermissionsButton = FieldToolkit.createCheckBox((Composite)parent, "Create Permissions", this.isCreatePermissions());
        this.m_createPermissionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormNewWizardPage.this.setIsCreatePermissionsInternal(FormNewWizardPage.this.m_createPermissionsButton.getSelection());
                FormNewWizardPage.this.handleComponentsChanged();
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_sharedSourceFolder = FieldToolkit.createSourceFolderField((Composite)parent, "Shared Source Folder", ScoutTier.Shared, this.getLabelWidth());
        this.m_sharedSourceFolder.acceptProposal(this.getSharedSourceFolder());
        this.m_sharedSourceFolder.addProposalListener(proposal -> {
            this.setSharedSourceFolderInternal((IPackageFragmentRoot)proposal);
            this.pingStateChanging();
        });
        this.m_serverSourceFolder = FieldToolkit.createSourceFolderField((Composite)parent, "Server Source Folder", ScoutTier.Server, this.getLabelWidth());
        this.m_serverSourceFolder.acceptProposal(this.getServerSourceFolder());
        this.m_serverSourceFolder.addProposalListener(proposal -> {
            this.setServerSourceFolderInternal((IPackageFragmentRoot)proposal);
            this.pingStateChanging();
        });
        GridDataFactory.defaultsFor((Control)parent).align(4, 0x1000000).grab(true, false).indent(0, 10).applyTo((Control)parent);
        GridLayoutFactory.swtDefaults().numColumns(3).equalWidth(true).applyTo((Composite)parent);
        GridDataFactory optionsButtonGridDataFactory = GridDataFactory.defaultsFor((Control)parent).indent(10, 8);
        GridDataFactory.defaultsFor((Control)this.m_sharedSourceFolder).align(4, 0x1000000).grab(true, false).span(3, 0).indent(0, 8).applyTo((Control)this.m_sharedSourceFolder);
        GridDataFactory.defaultsFor((Control)this.m_serverSourceFolder).align(4, 0x1000000).grab(true, false).span(3, 0).applyTo((Control)this.m_serverSourceFolder);
        optionsButtonGridDataFactory.applyTo((Control)this.m_createFormDataButton);
        optionsButtonGridDataFactory.applyTo((Control)this.m_createServiceButton);
        optionsButtonGridDataFactory.applyTo((Control)this.m_createPermissionsButton);
        this.handleComponentsChanged();
    }

    @Override
    protected void handleJavaProjectChanged() {
        super.handleJavaProjectChanged();
        this.guessSharedAndServerFolders();
    }

    protected void handleComponentsChanged() {
        this.m_sharedSourceFolder.setEnabled(this.isCreateFormData() || this.isCreatePermissions() || this.isCreateService());
        this.m_serverSourceFolder.setEnabled(this.isCreateService());
    }

    public boolean isCreateFormData() {
        return this.getPropertyBool("createFormData", true);
    }

    public void setIsCreateFormData(boolean createFormData) {
        this.setPropertyWithChangingControl(this.m_createFormDataButton, () -> this.setIsCreateFormDataInternal(createFormData), field -> field.setSelection(createFormData));
    }

    protected boolean setIsCreateFormDataInternal(boolean createFormData) {
        return this.setProperty("createFormData", createFormData);
    }

    public boolean isCreateService() {
        return this.getPropertyBool("createService", true);
    }

    public void setIsCreateService(boolean createService) {
        this.setPropertyWithChangingControl(this.m_createServiceButton, () -> this.setIsCreateServiceInternal(createService), field -> field.setSelection(createService));
    }

    protected boolean setIsCreateServiceInternal(boolean createService) {
        return this.setProperty("createService", createService);
    }

    public boolean isCreatePermissions() {
        return this.getPropertyBool("createPermissions", true);
    }

    public void setIsCreatePermissions(boolean createPermissions) {
        this.setPropertyWithChangingControl(this.m_createPermissionsButton, () -> this.setIsCreatePermissionsInternal(createPermissions), field -> field.setSelection(createPermissions));
    }

    protected boolean setIsCreatePermissionsInternal(boolean createPermissions) {
        return this.setProperty("createPermissions", createPermissions);
    }

    public IPackageFragmentRoot getSharedSourceFolder() {
        return this.getProperty(PROP_SHARED_SOURCE_FOLDER, IPackageFragmentRoot.class);
    }

    public void setSharedSourceFolder(IPackageFragmentRoot sharedSourceFolder) {
        this.setPropertyWithChangingControl(this.m_sharedSourceFolder, () -> this.setSharedSourceFolderInternal(sharedSourceFolder), field -> field.acceptProposal(sharedSourceFolder));
    }

    protected boolean setSharedSourceFolderInternal(IPackageFragmentRoot sharedSourceFolder) {
        return this.setProperty(PROP_SHARED_SOURCE_FOLDER, sharedSourceFolder);
    }

    public IPackageFragmentRoot getServerSourceFolder() {
        return this.getProperty(PROP_SERVER_SOURCE_FOLDER, IPackageFragmentRoot.class);
    }

    public void setServerSourceFolder(IPackageFragmentRoot serverSourceFolder) {
        this.setPropertyWithChangingControl(this.m_serverSourceFolder, () -> this.setServerSourceFolderInternal(serverSourceFolder), field -> field.acceptProposal(serverSourceFolder));
    }

    protected boolean setServerSourceFolderInternal(IPackageFragmentRoot serverSourceFolder) {
        return this.setProperty(PROP_SERVER_SOURCE_FOLDER, serverSourceFolder);
    }
}

