/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.matcher;

import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.WidgetHandler;
import org.eclipse.swt.widgets.Widget;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class WithStyleMatcher
extends BaseMatcher<Integer> {
    private int style;

    public WithStyleMatcher(int style) {
        this.style = style;
    }

    public boolean matches(Object item) {
        if (item instanceof Widget) {
            try {
                Integer widgetStyle = WidgetHandler.getInstance().getStyle((Widget)item);
                return (widgetStyle & this.style) == this.style;
            }
            catch (CoreLayerException coreLayerException) {
                return false;
            }
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("has style " + this.style);
    }

    public String toString() {
        return "Widget matcher matching widgets with style: " + this.style;
    }
}

