/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui;

import java.util.function.Consumer;
import org.eclipse.net4j.util.collection.ConcurrentArray;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GlobalPartAdapter
implements IWindowListener,
IPageListener,
IPartListener2 {
    private static final ConcurrentArray<GlobalPartAdapter> adapters = new ConcurrentArray<GlobalPartAdapter>(){

        protected GlobalPartAdapter[] newArray(int length) {
            return new GlobalPartAdapter[length];
        }
    };

    static {
        final IPartListener2 partListener = new IPartListener2(){

            public void partOpened(IWorkbenchPartReference partRef) {
                GlobalPartAdapter.notifyAdapters(a -> a.partOpened(partRef));
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                GlobalPartAdapter.notifyAdapters(a -> a.partClosed(partRef));
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                GlobalPartAdapter.notifyAdapters(a -> a.partActivated(partRef));
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
                GlobalPartAdapter.notifyAdapters(a -> a.partDeactivated(partRef));
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
                GlobalPartAdapter.notifyAdapters(a -> a.partBroughtToTop(partRef));
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                GlobalPartAdapter.notifyAdapters(a -> a.partHidden(partRef));
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                GlobalPartAdapter.notifyAdapters(a -> a.partVisible(partRef));
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
                GlobalPartAdapter.notifyAdapters(a -> a.partInputChanged(partRef));
            }
        };
        final IPageListener pageListener = new IPageListener(){

            public void pageOpened(IWorkbenchPage page) {
                page.addPartListener(partListener);
                GlobalPartAdapter.notifyAdapters(a -> a.pageOpened(page));
            }

            public void pageClosed(IWorkbenchPage page) {
                page.removePartListener(partListener);
                GlobalPartAdapter.notifyAdapters(a -> a.pageClosed(page));
            }

            public void pageActivated(IWorkbenchPage page) {
                GlobalPartAdapter.notifyAdapters(a -> a.pageActivated(page));
            }
        };
        IWindowListener windowListener = new IWindowListener(){

            public void windowOpened(IWorkbenchWindow window) {
                window.addPageListener(pageListener);
                GlobalPartAdapter.notifyAdapters(a -> a.windowOpened(window));
            }

            public void windowClosed(IWorkbenchWindow window) {
                window.removePageListener(pageListener);
                GlobalPartAdapter.notifyAdapters(a -> a.windowOpened(window));
            }

            public void windowActivated(IWorkbenchWindow window) {
                GlobalPartAdapter.notifyAdapters(a -> a.windowClosed(window));
            }

            public void windowDeactivated(IWorkbenchWindow window) {
                GlobalPartAdapter.notifyAdapters(a -> a.windowDeactivated(window));
            }
        };
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.addWindowListener(windowListener);
    }

    public GlobalPartAdapter() {
        adapters.add((Object)this);
    }

    public void dispose() {
        adapters.remove((Object)this);
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void pageClosed(IWorkbenchPage page) {
    }

    public void pageOpened(IWorkbenchPage page) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    private static void notifyAdapters(Consumer<GlobalPartAdapter> consumer) {
        GlobalPartAdapter[] array = (GlobalPartAdapter[])adapters.get();
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                GlobalPartAdapter adapter = array[i];
                try {
                    consumer.accept(adapter);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
                ++i;
            }
        }
    }
}

