/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project.builder;

import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.compiler.ResolverUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.project.Messages;
import org.eclipse.m2m.internal.qvt.oml.project.QVTOProjectPlugin;
import org.eclipse.m2m.internal.qvt.oml.project.builder.QVTOBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.project.builder.WorkspaceUnitResolver;

public class WorkspaceUnitResolverFactory
extends UnitResolverFactory {
    public boolean accepts(URI uri) {
        return EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE && (uri.isPlatformResource() || WorkspaceUnitResolverFactory.isWorkspacePath(uri));
    }

    public UnitResolver getResolver(URI uri) {
        block5: {
            IContainer sourceContainer;
            block6: {
                IResource file;
                if (WorkspaceUnitResolverFactory.isWorkspacePath(uri)) {
                    uri = URI.createPlatformResourceURI((String)uri.path(), (boolean)false);
                }
                if ((file = URIUtils.getResource((URI)uri)) == null) {
                    return null;
                }
                sourceContainer = QVTOBuilderConfig.getConfig(file.getProject()).getSourceContainer();
                if (sourceContainer == null) break block5;
                if (sourceContainer.exists()) break block6;
                QVTOProjectPlugin.log(QVTOProjectPlugin.createStatus(4, NLS.bind((String)Messages.InvalidSourceContainer, (Object)sourceContainer), null));
                return null;
            }
            try {
                return new WorkspaceUnitResolver(Collections.singletonList(sourceContainer));
            }
            catch (CoreException e) {
                QVTOProjectPlugin.log(e.getStatus());
            }
        }
        return null;
    }

    public String getQualifiedName(URI uri) {
        IResource resource;
        if (WorkspaceUnitResolverFactory.isWorkspacePath(uri)) {
            uri = URI.createPlatformResourceURI((String)uri.path(), (boolean)false);
        }
        if ((resource = URIUtils.getResource((URI)uri)) == null) {
            return null;
        }
        try {
            IContainer sourceContainer = QVTOBuilderConfig.getConfig(resource.getProject()).getSourceContainer();
            URI sourceContainerUri = URIUtils.getResourceURI((IResource)sourceContainer);
            URI relativeUri = uri.deresolve(sourceContainerUri).trimFileExtension();
            assert (relativeUri.isRelative());
            String[] segments = relativeUri.segments();
            if (segments.length > 1) {
                return ResolverUtils.toQualifiedName((String[])segments, (int)1, (int)(segments.length - 1));
            }
        }
        catch (CoreException e) {
            QVTOProjectPlugin.log(e.getStatus());
        }
        return null;
    }

    private static boolean isWorkspacePath(URI uri) {
        return uri.scheme() == null && !uri.hasDevice() && !uri.hasAuthority() && !uri.hasEmptyPath() && !uri.hasQuery() && !uri.hasFragment() && uri.hasAbsolutePath();
    }
}

