/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.conversion;

import org.eclipse.gef.dot.internal.language.DotAstHelper;
import org.eclipse.gef.dot.internal.language.color.Color;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.color.HSVColor;
import org.eclipse.gef.dot.internal.language.color.RGBColor;
import org.eclipse.gef.dot.internal.language.color.StringColor;
import org.eclipse.gef.dot.internal.language.dot.Attribute;

public class DotColorInfo {
    private Attribute attribute;
    private Color color;
    private String colorScheme;
    private String colorName;
    private String colorCode;

    public DotColorInfo(Attribute attribute, Color color) {
        this.attribute = attribute;
        this.color = color;
    }

    public void calculate() {
        this.calculate(this.attribute.getValue().toValue());
    }

    public void calculate(String value) {
        if (this.color == null) {
            return;
        }
        if (this.color instanceof StringColor) {
            StringColor stringColor = (StringColor)this.color;
            this.colorScheme = stringColor.getScheme();
            if (this.colorScheme == null) {
                this.colorScheme = DotAstHelper.getColorSchemeAttributeValue((Attribute)this.attribute);
            }
            if (this.colorScheme == null) {
                this.colorScheme = "x11";
            }
            this.colorName = stringColor.getName();
            this.colorCode = DotColors.get((String)this.colorScheme, (String)this.colorName);
        }
        if (this.color instanceof RGBColor) {
            this.colorCode = value;
        }
        boolean cfr_ignored_0 = this.color instanceof HSVColor;
    }

    public String getColorScheme() {
        return this.colorScheme;
    }

    public String getColorName() {
        return this.colorName;
    }

    public String getColorCode() {
        return this.colorCode;
    }
}

