/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.ui.css.core.dom.IElementProvider;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.w3c.dom.Element;

public class RegistryCSSElementProvider
implements IElementProvider {
    private static final String ELEMENT_PROVIDER_EXTPOINT = "org.eclipse.e4.ui.css.core.elementProvider";
    private final IExtensionRegistry registry;
    private Map<Class<?>, IElementProvider> providerCache = Collections.synchronizedMap(new WeakHashMap());

    public RegistryCSSElementProvider(IExtensionRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Element getElement(Object o, CSSEngine engine) {
        if (o instanceof Element) {
            return (Element)o;
        }
        IElementProvider provider = this.providerCache.get(o.getClass());
        if (provider != null) {
            return provider.getElement(o, engine);
        }
        for (Class<?> type : this.computeElementTypeLookup(o.getClass())) {
            String typeName = type.getName();
            IConfigurationElement[] iConfigurationElementArray = this.registry.getConfigurationElementsFor(ELEMENT_PROVIDER_EXTPOINT);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                if ("provider".equals(ce.getName())) {
                    IConfigurationElement[] iConfigurationElementArray2 = ce.getChildren();
                    int n3 = iConfigurationElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement ce2 = iConfigurationElementArray2[n4];
                        if (typeName.equals(ce2.getAttribute("class"))) {
                            try {
                                provider = (IElementProvider)ce.createExecutableExtension("class");
                                this.providerCache.put(o.getClass(), provider);
                                return provider.getElement(o, engine);
                            }
                            catch (CoreException e1) {
                                e1.printStackTrace();
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private List<Class<?>> computeElementTypeLookup(Class<?> clazz) {
        ArrayList results = new ArrayList();
        LinkedList todo = new LinkedList();
        HashSet<Class> seen = new HashSet<Class>();
        todo.add(clazz);
        while (!todo.isEmpty()) {
            Class candidate = (Class)todo.removeFirst();
            if (seen.contains(candidate)) continue;
            seen.add(candidate);
            results.add(candidate);
            Collections.addAll(todo, candidate.getInterfaces());
            if (candidate.getSuperclass() == null) continue;
            todo.add(candidate.getSuperclass());
        }
        return results;
    }
}

