/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.util;

import org.eclipse.dltk.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class SWTFactory {
    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static void setButtonDimensionHint(Button button) {
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = SWTFactory.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    public static Button createPushButtonNoLayoutData(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (label != null) {
            button.setText(label);
        }
        return button;
    }

    public static Button createPushButton(Composite parent, String label) {
        return SWTFactory.createPushButton(parent, label, null);
    }

    public static Button createPushButton(Composite parent, String label, Image image) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        SWTFactory.setButtonDimensionHint(button);
        return button;
    }

    public static Button createPushButton(Composite parent, String label, String tooltip, Image image) {
        Button button = SWTFactory.createPushButton(parent, label, image);
        button.setToolTipText(tooltip);
        return button;
    }

    public static Button createRadioButton(Composite parent, String label) {
        return SWTFactory.createRadioButton(parent, label, 1);
    }

    public static Button createRadioButton(Composite parent, String label, int hspan) {
        Button button = new Button(parent, 16);
        button.setFont(parent.getFont());
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData(1);
        gd.horizontalSpan = hspan;
        button.setLayoutData((Object)gd);
        SWTFactory.setButtonDimensionHint(button);
        return button;
    }

    public static Button createRadioButtonNoLayoutData(Composite parent, String label) {
        Button button = new Button(parent, 16);
        button.setFont(parent.getFont());
        if (label != null) {
            button.setText(label);
        }
        return button;
    }

    public static Button createCheckButton(Composite parent, String label) {
        return SWTFactory.createCheckButton(parent, label, 1);
    }

    public static Button createCheckButton(Composite parent, String label, int hspan) {
        return SWTFactory.createCheckButton(parent, label, null, false, hspan);
    }

    public static Button createCheckButton(Composite parent, String label, Image image, boolean checked, int hspan) {
        Button button = new Button(parent, 32);
        button.setFont(parent.getFont());
        button.setSelection(checked);
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        gd.horizontalSpan = hspan;
        button.setLayoutData((Object)gd);
        SWTFactory.setButtonDimensionHint(button);
        return button;
    }

    public static Label createLabel(Composite parent, String text, Font font, int hspan) {
        return SWTFactory.createLabel(parent, text, 0, font, hspan);
    }

    public static Label createLabel(Composite parent, String text, int indent, Font font, int hspan) {
        Label l = new Label(parent, 0);
        l.setFont(font);
        l.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = hspan;
        gd.horizontalIndent = indent;
        l.setLayoutData((Object)gd);
        return l;
    }

    public static Label createLabel(Composite parent, String text, int indent, int hspan) {
        return SWTFactory.createLabel(parent, text, indent, parent.getFont(), hspan);
    }

    public static Label createLabel(Composite parent, String text, int hspan) {
        return SWTFactory.createLabel(parent, text, 0, hspan);
    }

    public static Label createWrapLabel(Composite parent, String text, int hspan, int wrapwidth) {
        Label l = SWTFactory.createLabel(parent, text, 0, parent.getFont(), hspan);
        ((GridData)l.getLayoutData()).widthHint = wrapwidth;
        return l;
    }

    public static Text createSingleText(Composite parent, int hspan) {
        Text t = new Text(parent, 2052);
        t.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        t.setLayoutData((Object)gd);
        return t;
    }

    public static Text createText(Composite parent, int style, int hspan, String text) {
        return SWTFactory.createText(parent, style, hspan, text, 768);
    }

    public static Text createText(Composite parent, int style, int hspan, String text, int fill) {
        Text t = new Text(parent, style);
        t.setFont(parent.getFont());
        SWTFactory.makeScrollableCompositeAware((Control)parent);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        t.setLayoutData((Object)gd);
        t.setText(text);
        return t;
    }

    public static Group createGroup(Composite parent, String text, int columns, int hspan, int fill) {
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        return SWTFactory.createGroup(parent, text, columns, gd);
    }

    @Deprecated
    public static Group createGroup(Composite parent, String text, int columns, int hspan, GridData data) {
        return SWTFactory.createGroup(parent, text, columns, data);
    }

    public static Group createGroup(Composite parent, String text, int columns, GridData data) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setText(text);
        g.setFont(parent.getFont());
        g.setLayoutData((Object)data);
        return g;
    }

    public static void showPreferencePage(String id) {
        SWTFactory.showPreferencePage(id, new String[]{id});
    }

    public static void showPreferencePage(String page_id, String[] page_filters) {
        PreferencesUtil.createPreferenceDialogOn((Shell)DLTKUIPlugin.getActiveWorkbenchShell(), (String)page_id, (String[])page_filters, null).open();
    }

    public static Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill) {
        Composite g = new Composite(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    public static Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        Composite g = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginwidth;
        layout.marginHeight = marginheight;
        g.setLayout((Layout)layout);
        g.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    public static void createVerticalSpacer(Composite comp, int numlines) {
        Label lbl = new Label(comp, 0);
        GridData gd = new GridData(768);
        gd.heightHint = numlines;
        lbl.setLayoutData((Object)gd);
    }

    public static void createHorizontalSpacer(Composite comp, int hspan) {
        Label lbl = new Label(comp, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        lbl.setLayoutData((Object)gd);
    }

    public static Combo createCombo(Composite parent, int style, int hspan, int fill, String[] items) {
        Combo c = new Combo(parent, style);
        c.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        c.setLayoutData((Object)gd);
        c.setItems(items);
        c.select(0);
        return c;
    }

    public static Combo createCombo(Composite parent, int style, int hspan, String[] items) {
        return SWTFactory.createCombo(parent, style, hspan, 768, items);
    }

    public static ExpandableComposite createExpandibleComposite(Composite parent, int style, String label, int hspan, int fill) {
        ExpandableComposite ex = new ExpandableComposite(parent, 0, style);
        ex.setText(label);
        ex.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        ex.setLayoutData((Object)gd);
        return ex;
    }

    private static ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    private static void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent parentScrolledComposite = SWTFactory.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }
}

