/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.util;

import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TypeNameMatchLabelProvider
extends LabelProvider {
    public static final int SHOW_FULLYQUALIFIED = 1;
    public static final int SHOW_PACKAGE_POSTFIX = 2;
    public static final int SHOW_PACKAGE_ONLY = 4;
    public static final int SHOW_ROOT_POSTFIX = 8;
    public static final int SHOW_TYPE_ONLY = 16;
    public static final int SHOW_TYPE_CONTAINER_ONLY = 32;
    public static final int SHOW_POST_QUALIFIED = 64;
    private static final Image CLASS_ICON = DLTKPluginImages.get("org.eclipse.dltk.ui.class_obj.png");
    private static final Image ANNOTATION_ICON = DLTKPluginImages.get("org.eclipse.dltk.ui.annotation_obj.png");
    private static final Image PKG_ICON = DLTKPluginImages.get("org.eclipse.dltk.ui.package_obj.png");
    private final int fFlags;
    private final IDLTKUILanguageToolkit fToolkit;

    public TypeNameMatchLabelProvider(int flags, IDLTKUILanguageToolkit toolkit) {
        this.fFlags = flags;
        this.fToolkit = toolkit;
    }

    private boolean isSet(int flag) {
        return (this.fFlags & flag) != 0;
    }

    private String getPackageName(String packName) {
        if (packName.length() == 0) {
            return DLTKUIMessages.TypeInfoLabelProvider_default_package;
        }
        return packName;
    }

    public String getText(Object element) {
        String packName;
        String containerName;
        if (!(element instanceof TypeNameMatch)) {
            return super.getText(element);
        }
        TypeNameMatch typeRef = (TypeNameMatch)element;
        StringBuffer buf = new StringBuffer();
        if (this.isSet(16)) {
            buf.append(typeRef.getSimpleTypeName());
        } else if (this.isSet(32)) {
            containerName = typeRef.getTypeContainerName();
            buf.append(this.getPackageName(containerName));
        } else if (this.isSet(4)) {
            packName = typeRef.getPackageName();
            buf.append(this.getPackageName(packName));
        } else {
            if (this.isSet(1)) {
                buf.append(typeRef.getFullyQualifiedName());
            } else if (this.isSet(64)) {
                buf.append(typeRef.getSimpleTypeName());
                containerName = typeRef.getTypeContainerName();
                if (containerName != null && containerName.length() > 0) {
                    buf.append(" - ");
                    buf.append(containerName);
                }
            } else {
                buf.append(typeRef.getTypeQualifiedName());
            }
            if (this.isSet(2)) {
                buf.append(" - ");
                packName = typeRef.getPackageName();
                buf.append(this.getPackageName(packName));
            }
        }
        if (this.isSet(8)) {
            buf.append(" - ");
            IProjectFragment root = typeRef.getProjectFragment();
            ScriptElementLabels labels = this.fToolkit.getScriptElementLabels();
            labels.getProjectFragmentLabel(root, 0x20000000000L, buf);
        }
        return buf.toString();
    }

    public Image getImage(Object element) {
        if (!(element instanceof TypeNameMatch)) {
            return super.getImage(element);
        }
        if (this.isSet(32)) {
            TypeNameMatch typeRef = (TypeNameMatch)element;
            if (typeRef.getPackageName().equals(typeRef.getTypeContainerName())) {
                return PKG_ICON;
            }
            return CLASS_ICON;
        }
        if (this.isSet(4)) {
            return PKG_ICON;
        }
        int modifiers = ((TypeNameMatch)element).getModifiers();
        if ((modifiers & 0x1000) != 0) {
            return ANNOTATION_ICON;
        }
        return CLASS_ICON;
    }
}

