/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness;

import org.junit.Assert;

public class TestBarrier {
    public static final int STATUS_BLOCKED = 6;
    public static final int STATUS_DONE = 5;
    public static final int STATUS_RUNNING = 3;
    public static final int STATUS_START = 1;
    public static final int STATUS_WAIT_FOR_DONE = 4;
    public static final int STATUS_WAIT_FOR_RUN = 2;
    public static final int STATUS_WAIT_FOR_START = 0;
    private final int myIndex;
    private final int[] myStatus;

    private static void doWaitForStatus(int[] statuses, int index, int status, int timeout) {
        long start = System.currentTimeMillis();
        int i = 0;
        while (statuses[index] != status) {
            try {
                Thread.yield();
                Thread.sleep(100L);
                Thread.yield();
            }
            catch (InterruptedException interruptedException) {}
            long elapsed = System.currentTimeMillis() - start;
            Assert.assertTrue((String)("Timeout after " + elapsed + "ms waiting for status to change from " + TestBarrier.getStatus(statuses[index]) + " to " + TestBarrier.getStatus(status)), (i++ < timeout ? 1 : 0) != 0);
        }
    }

    private static String getStatus(int status) {
        switch (status) {
            case 0: {
                return "WAIT_FOR_START";
            }
            case 1: {
                return "START";
            }
            case 2: {
                return "WAIT_FOR_RUN";
            }
            case 3: {
                return "RUNNING";
            }
            case 4: {
                return "WAIT_FOR_DONE";
            }
            case 5: {
                return "DONE";
            }
            case 6: {
                return "BLOCKED";
            }
        }
        return "UNKNOWN_STATUS";
    }

    public static void waitForStatus(int[] location, int status) {
        TestBarrier.doWaitForStatus(location, 0, status, 100);
    }

    public static void waitForStatus(int[] location, int index, int status) {
        TestBarrier.doWaitForStatus(location, index, status, 500);
    }

    public TestBarrier() {
        this(new int[1], 0);
    }

    public TestBarrier(int initalStatus) {
        this(new int[]{initalStatus}, 0);
    }

    public TestBarrier(int[] location, int index) {
        this.myStatus = location;
        this.myIndex = index;
    }

    public void setStatus(int status) {
        this.myStatus[this.myIndex] = status;
    }

    public void waitForStatus(int status) {
        TestBarrier.waitForStatus(this.myStatus, this.myIndex, status);
    }

    public void waitForStatusNoFail(int status) {
        TestBarrier.doWaitForStatus(this.myStatus, this.myIndex, status, 100000);
    }
}

