/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.jsoncdb.core.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.cdt.jsoncdb.core.internal.Plugin;
import org.eclipse.cdt.jsoncdb.core.internal.builtins.GccBuiltinDetectionBehavior;
import org.eclipse.cdt.jsoncdb.core.internal.builtins.MaybeGccBuiltinDetectionBehavior;
import org.eclipse.cdt.jsoncdb.core.participant.Arglets;
import org.eclipse.cdt.jsoncdb.core.participant.DefaultToolCommandlineParser;
import org.eclipse.cdt.jsoncdb.core.participant.DefaultToolDetectionParticipant;
import org.eclipse.cdt.jsoncdb.core.participant.IArglet;
import org.eclipse.cdt.jsoncdb.core.participant.IToolDetectionParticipant;
import org.eclipse.cdt.jsoncdb.core.participant.ResponseFileArglets;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public final class ParserDetection {
    private static final ILog log = Plugin.getDefault().getLog();
    private static final boolean DEBUG_PARTCIPANT_DETECTION = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.jsoncdb.core/debug/participant"));
    private static List<IToolDetectionParticipant> parserDetectors;

    static void init() {
        if (parserDetectors == null) {
            parserDetectors = new ArrayList<IToolDetectionParticipant>(22);
            IArglet[] gcc_args = new IArglet[]{new Arglets.IncludePath_C_POSIX(), new Arglets.MacroDefine_C_POSIX(), new Arglets.MacroUndefine_C_POSIX(), new Arglets.SystemIncludePath_C(), new Arglets.LangStd_GCC(), new Arglets.Sysroot_GCC(), new Arglets.IncludeFile_GCC(), new Arglets.MacrosFile_GCC()};
            MaybeGccBuiltinDetectionBehavior btbGccMaybee = new MaybeGccBuiltinDetectionBehavior();
            GccBuiltinDetectionBehavior btbGcc = new GccBuiltinDetectionBehavior();
            DefaultToolCommandlineParser cc = new DefaultToolCommandlineParser(new ResponseFileArglets.At(), btbGccMaybee, gcc_args);
            parserDetectors.add(new DefaultToolDetectionParticipant("cc", true, "exe", cc));
            DefaultToolCommandlineParser cxx = new DefaultToolCommandlineParser(new ResponseFileArglets.At(), btbGccMaybee, gcc_args);
            parserDetectors.add(new DefaultToolDetectionParticipant("c\\+\\+", true, "exe", cxx));
            DefaultToolCommandlineParser gcc = new DefaultToolCommandlineParser(new ResponseFileArglets.At(), btbGcc, gcc_args);
            parserDetectors.add(new DefaultToolDetectionParticipant("gcc", true, "exe", gcc));
            parserDetectors.add(new DefaultToolDetectionParticipant("clang", true, "exe", gcc));
            parserDetectors.add(new DefaultToolDetectionParticipant("\\S+?-gcc", true, "exe", gcc));
            DefaultToolCommandlineParser gxx = new DefaultToolCommandlineParser(new ResponseFileArglets.At(), btbGcc, gcc_args);
            parserDetectors.add(new DefaultToolDetectionParticipant("g\\+\\+", true, "exe", gxx));
            parserDetectors.add(new DefaultToolDetectionParticipant("clang\\+\\+", true, "exe", gxx));
            parserDetectors.add(new DefaultToolDetectionParticipant("\\S+?-g\\+\\+", true, "exe", gxx));
            cxx = new DefaultToolCommandlineParser(new ResponseFileArglets.At(), btbGccMaybee, gcc_args);
            parserDetectors.add(new DefaultToolDetectionParticipant("\\S+?-c\\+\\+", true, "exe", cxx));
            ParserDetection.loadExtentionsSorted(parserDetectors::add);
        }
    }

    private static void loadExtentionsSorted(Consumer<? super IToolDetectionParticipant> consumer) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.cdt.jsoncdb.core.detectionParticipant");
        HashMap<IToolDetectionParticipant, Integer> sortMap = new HashMap<IToolDetectionParticipant, Integer>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object obj = e.createExecutableExtension("class");
                String attr = e.getAttribute("order");
                Integer order = Integer.MAX_VALUE;
                try {
                    order = Integer.parseUnsignedInt(Optional.ofNullable(attr).orElse("100000"));
                    order = Integer.max(10000, order);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (obj instanceof IToolDetectionParticipant) {
                    sortMap.put((IToolDetectionParticipant)obj, order);
                }
            }
            catch (CoreException ex) {
                log.log((IStatus)new Status(4, "org.eclipse.cdt.jsoncdb.core", e.getNamespaceIdentifier(), (Throwable)ex));
            }
            ++n2;
        }
        sortMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).forEach(consumer);
    }

    private ParserDetection() {
    }

    public static ParserDetectionResult determineDetector(String line, String versionSuffixRegex, boolean tryWindowsDetectors) {
        String shortPathExpanded;
        ParserDetectionResult result;
        if (DEBUG_PARTCIPANT_DETECTION) {
            System.out.printf("> Command-line '%s'%n", line);
            System.out.printf("> Looking up detector for command '%s ...'%n", line.substring(0, Math.min(40, line.length())));
        }
        if ((result = ParserDetection.determineDetector0(line, versionSuffixRegex, false)) == null && tryWindowsDetectors && (result = ParserDetection.determineDetector0(line, versionSuffixRegex, true)) == null && (result = ParserDetection.determineDetector0(shortPathExpanded = ParserDetection.expandShortFileName(line), versionSuffixRegex, false)) == null) {
            result = ParserDetection.determineDetector0(shortPathExpanded, versionSuffixRegex, true);
        }
        if (result != null && DEBUG_PARTCIPANT_DETECTION) {
            System.out.printf("< Found detector for command '%s': %s (%s)%n", new Object[]{result.getCommandLine().getCommand(), result.getDetectorWithMethod().getToolDetectionParticipant().getParser().getClass().getSimpleName(), result.getDetectorWithMethod().getHow()});
        }
        return result;
    }

    private static ParserDetectionResult determineDetector0(String commandLine, String versionSuffixRegex, boolean matchBackslash) {
        Optional<IToolDetectionParticipant.MatchResult> cmdline;
        ParserDetection.init();
        for (IToolDetectionParticipant pd : parserDetectors) {
            if (DEBUG_PARTCIPANT_DETECTION) {
                System.out.printf("  Trying participant %s (%s)%n", new Object[]{pd, DetectorWithMethod.DetectionMethod.BASENAME});
            }
            if (!(cmdline = pd.basenameMatches(commandLine, matchBackslash)).isPresent()) continue;
            return new ParserDetectionResult(new DetectorWithMethod(pd, DetectorWithMethod.DetectionMethod.BASENAME, matchBackslash), cmdline.get());
        }
        if (versionSuffixRegex != null) {
            for (IToolDetectionParticipant pd : parserDetectors) {
                if (DEBUG_PARTCIPANT_DETECTION) {
                    System.out.printf("  Trying participant %s (%s)%n", new Object[]{pd, DetectorWithMethod.DetectionMethod.WITH_VERSION});
                }
                if (!(cmdline = pd.basenameWithVersionMatches(commandLine, matchBackslash, versionSuffixRegex)).isPresent()) continue;
                return new ParserDetectionResult(new DetectorWithMethod(pd, DetectorWithMethod.DetectionMethod.WITH_VERSION, matchBackslash), cmdline.get());
            }
        }
        for (IToolDetectionParticipant pd : parserDetectors) {
            if (DEBUG_PARTCIPANT_DETECTION) {
                System.out.printf("  Trying participant %s (%s)%n", new Object[]{pd, DetectorWithMethod.DetectionMethod.WITH_EXTENSION});
            }
            if (!(cmdline = pd.basenameWithExtensionMatches(commandLine, matchBackslash)).isPresent()) continue;
            return new ParserDetectionResult(new DetectorWithMethod(pd, DetectorWithMethod.DetectionMethod.WITH_EXTENSION, matchBackslash), cmdline.get());
        }
        if (versionSuffixRegex != null) {
            for (IToolDetectionParticipant pd : parserDetectors) {
                if (DEBUG_PARTCIPANT_DETECTION) {
                    System.out.printf("  Trying participant %s (%s)%n", new Object[]{pd, DetectorWithMethod.DetectionMethod.WITH_VERSION_EXTENSION});
                }
                if (!(cmdline = pd.basenameWithVersionAndExtensionMatches(commandLine, matchBackslash, versionSuffixRegex)).isPresent()) continue;
                return new ParserDetectionResult(new DetectorWithMethod(pd, DetectorWithMethod.DetectionMethod.WITH_VERSION_EXTENSION, matchBackslash), cmdline.get());
            }
        }
        return null;
    }

    private static String expandShortFileName(String commandLine) {
        String command;
        if (commandLine.indexOf(126, 6) == -1) {
            return commandLine;
        }
        StringBuilder commandLine2 = new StringBuilder();
        int idx = commandLine.indexOf(32);
        if (idx != -1) {
            command = commandLine.substring(0, idx);
            commandLine2.append(commandLine.substring(idx));
        } else {
            command = commandLine;
        }
        try {
            command = new File(command).getCanonicalPath();
            commandLine2.insert(0, command);
            return commandLine2.toString();
        }
        catch (IOException e) {
            log.log((IStatus)new Status(4, "org.eclipse.cdt.jsoncdb.core", command, (Throwable)e));
            return commandLine;
        }
    }

    public static class DetectorWithMethod {
        private final IToolDetectionParticipant detector;
        private final DetectionMethod how;
        private final boolean matchBackslash;

        public DetectorWithMethod(IToolDetectionParticipant detector, DetectionMethod how, boolean matchBackslash) {
            if (detector == null) {
                throw new NullPointerException("detector");
            }
            if (how == null) {
                throw new NullPointerException("how");
            }
            this.detector = detector;
            this.how = how;
            this.matchBackslash = matchBackslash;
        }

        public IToolDetectionParticipant getToolDetectionParticipant() {
            return this.detector;
        }

        public DetectionMethod getHow() {
            return this.how;
        }

        public boolean isMatchBackslash() {
            return this.matchBackslash;
        }

        public static enum DetectionMethod {
            BASENAME,
            WITH_VERSION,
            WITH_EXTENSION,
            WITH_VERSION_EXTENSION;

        }
    }

    public static class ParserDetectionResult {
        private final DetectorWithMethod detectorWMethod;
        private final IToolDetectionParticipant.MatchResult commandLine;

        public ParserDetectionResult(DetectorWithMethod detectorWMethod, IToolDetectionParticipant.MatchResult commandLine) {
            this.detectorWMethod = detectorWMethod;
            this.commandLine = commandLine;
        }

        public IToolDetectionParticipant.MatchResult getCommandLine() {
            return this.commandLine;
        }

        public String getReducedCommandLine() {
            return this.commandLine.getArguments();
        }

        public DetectorWithMethod getDetectorWithMethod() {
            return this.detectorWMethod;
        }
    }
}

