/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.console;

import java.io.OutputStream;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.IGdbTerminalControlConnector;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;

public class GdbTerminalPageConnector
extends PlatformObject
implements ITerminalConnector {
    private int fTerminalWidth;
    private int fTerminalHeight;
    private ITerminalControl fControl;
    private final PTY fPty;
    private final IGdbTerminalControlConnector fGdbTerminalCtrlConnector;

    public GdbTerminalPageConnector(IGdbTerminalControlConnector gdbTerminalCtrlConnector, PTY pty) {
        this.fPty = pty;
        this.fGdbTerminalCtrlConnector = gdbTerminalCtrlConnector;
    }

    public void disconnect() {
        this.fGdbTerminalCtrlConnector.removePageTerminalControl(this.fControl);
        if (this.fControl != null) {
            this.fControl.setState(TerminalState.CLOSED);
        }
    }

    public OutputStream getTerminalToRemoteStream() {
        return this.fGdbTerminalCtrlConnector.getTerminalToRemoteStream();
    }

    public void connect(ITerminalControl control) {
        if (control == null) {
            throw new IllegalArgumentException("Invalid ITerminalControl");
        }
        this.fControl = control;
        this.fGdbTerminalCtrlConnector.addPageTerminalControl(this.fControl);
        this.fControl.setState(TerminalState.CONNECTED);
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        if (newWidth != this.fTerminalWidth || newHeight != this.fTerminalHeight) {
            this.fTerminalWidth = newWidth;
            this.fTerminalHeight = newHeight;
            if (this.fPty != null) {
                this.fPty.setTerminalSize(newWidth, newHeight);
            }
        }
    }

    public String getId() {
        return null;
    }

    public String getName() {
        return null;
    }

    public boolean isHidden() {
        return true;
    }

    public boolean isInitialized() {
        return true;
    }

    public String getInitializationErrorMessage() {
        return null;
    }

    public boolean isLocalEcho() {
        return false;
    }

    public void setDefaultSettings() {
    }

    public String getSettingsSummary() {
        return null;
    }

    public void load(ISettingsStore arg0) {
    }

    public void save(ISettingsStore arg0) {
    }
}

