/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.features.DefaultConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.Direction;
import org.eclipse.bpmn2.modeler.core.utils.AnchorSite;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class ConnectionRoute
implements Comparable<ConnectionRoute>,
Comparator<ConnectionRoute> {
    private DefaultConnectionRouter router;
    private int id;
    private List<Point> points = new ArrayList<Point>();
    private List<Point> special = new ArrayList<Point>();
    private List<Collision> collisions = new ArrayList<Collision>();
    private List<Crossing> crossings = new ArrayList<Crossing>();
    private Shape source;
    private AnchorSite sourceAnchorSite;
    private Point sourceAnchorLocation;
    private Shape target;
    private AnchorSite targetAnchorSite;
    private Point targetAnchorLocation;
    private boolean valid = true;
    private int rank = 0;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ConnectionRoute(DefaultConnectionRouter router, int id, Shape source, Shape target) {
        this.router = router;
        this.setId(id);
        this.source = source;
        this.target = target;
    }

    public void apply(FreeFormConnection ffc) {
        this.apply(ffc, null, null);
    }

    public void apply(FreeFormConnection ffc, FixPointAnchor sourceAnchor, FixPointAnchor targetAnchor) {
        Point p = this.get(0);
        if (sourceAnchor == null) {
            sourceAnchor = AnchorUtil.createAnchor((AnchorContainer)this.source, p);
            ffc.setStart((Anchor)sourceAnchor);
        } else {
            AnchorUtil.moveAnchor(sourceAnchor, p);
            if (this.sourceAnchorSite != null) {
                AnchorUtil.moveAnchor(sourceAnchor, this.sourceAnchorLocation);
                AnchorSite.setSite(sourceAnchor, this.sourceAnchorSite);
                AnchorUtil.adjustAnchors((AnchorContainer)this.source);
            }
        }
        p = this.get(this.size() - 1);
        if (targetAnchor == null) {
            targetAnchor = AnchorUtil.createAnchor((AnchorContainer)this.target, p);
            ffc.setEnd((Anchor)targetAnchor);
        } else {
            AnchorUtil.moveAnchor(targetAnchor, p);
            if (this.targetAnchorSite != null) {
                AnchorUtil.moveAnchor(targetAnchor, this.targetAnchorLocation);
                AnchorSite.setSite(targetAnchor, this.targetAnchorSite);
                AnchorUtil.adjustAnchors((AnchorContainer)this.target);
            }
        }
        ffc.getBendpoints().clear();
        int i = 1;
        while (i < this.size() - 1) {
            ffc.getBendpoints().add((Object)this.get(i));
            ++i;
        }
    }

    public String toString() {
        Object c;
        Iterator<Object> iter;
        int size = this.getPoints().size();
        Point p0 = size == 0 ? null : this.getPoints().get(0);
        Point p1 = size == 0 ? null : this.getPoints().get(size - 1);
        String start = p0 == null ? "null" : String.valueOf(p0.getX()) + "," + p0.getY();
        String end = p1 == null ? "null" : String.valueOf(p1.getX()) + "," + p1.getY();
        String text = String.valueOf(String.format("%3d", this.getId())) + (this.valid ? " :" : "X:") + " rank=" + this.rank + " length=" + this.getLength() + " points=" + this.getPoints().size() + " source=" + (Object)((Object)this.sourceAnchorSite) + " " + start + " target=" + (Object)((Object)this.targetAnchorSite) + " " + end;
        if (this.collisions.size() > 0) {
            text = String.valueOf(text) + " collisions=";
            iter = this.collisions.iterator();
            while (iter.hasNext()) {
                c = (Collision)iter.next();
                text = String.valueOf(text) + "'" + ((Collision)c).toString() + "'";
                if (!iter.hasNext()) continue;
                text = String.valueOf(text) + ", ";
            }
        }
        if (this.crossings.size() > 0) {
            text = String.valueOf(text) + " crossings=";
            iter = this.crossings.iterator();
            while (iter.hasNext()) {
                c = (Crossing)iter.next();
                text = String.valueOf(text) + "'" + ((Crossing)c).toString() + "'";
                if (!iter.hasNext()) continue;
                text = String.valueOf(text) + ", ";
            }
        }
        return text;
    }

    public void setSourceAnchor(FixPointAnchor sourceAnchor) {
        this.sourceAnchorSite = AnchorSite.getSite(sourceAnchor);
        this.sourceAnchorLocation = GraphicsUtil.createPoint((Anchor)sourceAnchor);
    }

    public void setTargetAnchor(FixPointAnchor targetAnchor) {
        this.targetAnchorSite = AnchorSite.getSite(targetAnchor);
        this.targetAnchorLocation = GraphicsUtil.createPoint((Anchor)targetAnchor);
    }

    public AnchorSite getSourceAnchorSite() {
        return this.sourceAnchorSite;
    }

    public AnchorSite getTargetAnchorSite() {
        return this.targetAnchorSite;
    }

    public boolean add(Point newPoint) {
        for (Point p : this.getPoints()) {
            if (!GraphicsUtil.pointsEqual(newPoint, p)) continue;
            this.setValid(false);
            return false;
        }
        this.getPoints().add(GraphicsUtil.createPoint(newPoint));
        return true;
    }

    public boolean add(int index, Point newPoint) {
        for (Point p : this.getPoints()) {
            if (!GraphicsUtil.pointsEqual(newPoint, p)) continue;
            this.setValid(false);
            return false;
        }
        this.getPoints().add(index, GraphicsUtil.createPoint(newPoint));
        return true;
    }

    public boolean addAll(List<Point> list) {
        for (Point p : list) {
            this.add(p);
        }
        return this.isValid();
    }

    public boolean contains(Point newPoint) {
        for (Point p : this.getPoints()) {
            if (!GraphicsUtil.pointsEqual(newPoint, p)) continue;
            return true;
        }
        return false;
    }

    public void addSpecial(Point p) {
        if (p != null) {
            this.special.add(p);
        }
    }

    public boolean isSpecial(Point p) {
        return this.special.contains(p);
    }

    public Point get(int index) {
        return this.getPoints().get(index);
    }

    public int size() {
        return this.getPoints().size();
    }

    public void addCollision(Shape shape, Point start, Point end) {
        if (shape != null) {
            for (Collision c : this.collisions) {
                if (c.shape != shape) continue;
                return;
            }
            this.collisions.add(new Collision(shape, start, end));
        }
    }

    public List<Collision> getCollisions() {
        return this.collisions;
    }

    public void addCrossing(Connection connection, Point start, Point end) {
        this.crossings.add(new Crossing(connection, start, end));
    }

    public List<Crossing> getCrossings() {
        return this.crossings;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        if (this.valid) {
            return this.getLength() < Integer.MAX_VALUE;
        }
        return false;
    }

    public int getLength() {
        int length = 0;
        if (this.getPoints().size() > 1) {
            Point p1 = this.getPoints().get(0);
            int i = 1;
            while (i < this.getPoints().size()) {
                Point p2 = this.getPoints().get(i);
                length += (int)GraphicsUtil.getLength(p1, p2);
                p1 = p2;
                ++i;
            }
        } else {
            return Integer.MAX_VALUE;
        }
        return length;
    }

    @Override
    public int compareTo(ConnectionRoute arg0) {
        return this.compare(this, arg0);
    }

    @Override
    public int compare(ConnectionRoute o1, ConnectionRoute o2) {
        int i = 0;
        int v1 = o1.isValid() ? 1 : 0;
        int v2 = o2.isValid() ? 1 : 0;
        i = v2 - v1;
        if (i == 0 && (i = o1.collisions.size() - o2.collisions.size()) == 0 && (i = o1.crossings.size() - o2.crossings.size()) == 0 && (i = o1.getRank() - o2.getRank()) == 0 && (i = o1.getPoints().size() - o2.getPoints().size()) == 0 && (i = o1.getLength() - o2.getLength()) == 0) {
            i = o1.getPoints().size() - o2.getPoints().size();
        }
        return i;
    }

    private boolean removeUnusedPoints() {
        boolean changed = false;
        Point p1 = this.getPoints().get(0);
        int i = 1;
        while (i < this.getPoints().size() - 1) {
            Point p2 = this.getPoints().get(i);
            if (!this.isSpecial(p2) && i + 1 < this.getPoints().size()) {
                boolean remove = false;
                if (GraphicsUtil.pointsEqual(p1, p2)) {
                    remove = true;
                } else {
                    Point p3 = this.getPoints().get(i + 1);
                    int x1 = p1.getX();
                    int x2 = p2.getX();
                    int x3 = p3.getX();
                    int y1 = p1.getY();
                    int y2 = p2.getY();
                    int y3 = p3.getY();
                    if ((GraphicsUtil.isVertical(p1, p2) && GraphicsUtil.isVertical(p2, p3) && (y1 < y2 && y2 < y3 || y1 > y2 && y2 > y3) || GraphicsUtil.isHorizontal(p1, p2) && GraphicsUtil.isHorizontal(p2, p3) && (x1 < x2 && x2 < x3 || x1 > x2 && x2 > x3)) && this.router.getCollision(p1, p3) == null) {
                        remove = true;
                    }
                }
                if (remove) {
                    this.getPoints().remove(i);
                    --i;
                    changed = true;
                }
            }
            p1 = p2;
            ++i;
        }
        return changed;
    }

    private boolean removeUnusedSegments() {
        Point p3;
        Point p2;
        boolean changed = false;
        Point p1 = this.getPoints().get(1);
        int i = 2;
        while (i < this.getPoints().size() - 2) {
            p2 = this.getPoints().get(i);
            if (!this.isSpecial(p2) && i + 2 < this.getPoints().size() && !this.isSpecial(p3 = this.getPoints().get(i + 1))) {
                Point p;
                Point p4 = this.getPoints().get(i + 2);
                if (GraphicsUtil.isHorizontal(p1, p2) && GraphicsUtil.isVertical(p2, p3) && GraphicsUtil.isHorizontal(p3, p4)) {
                    if (Direction.get(p1, p2) != Direction.get(p3, p4)) {
                        p = GraphicsUtil.createPoint(p1.getX(), p3.getY());
                        if (this.router.getCollision(p1, p) == null) {
                            this.getPoints().set(i + 1, p);
                            this.getPoints().remove(p2);
                            this.getPoints().remove(p3);
                            --i;
                            changed = true;
                        }
                    } else {
                        p = GraphicsUtil.createPoint(p1.getX(), p3.getY());
                        if (this.router.getCollision(p1, p) == null && this.router.getCollision(p, p3) == null) {
                            this.getPoints().set(i, p);
                            --i;
                            changed = true;
                        }
                    }
                } else if (GraphicsUtil.isVertical(p1, p2) && GraphicsUtil.isHorizontal(p2, p3) && GraphicsUtil.isVertical(p3, p4)) {
                    if (Direction.get(p1, p2) != Direction.get(p3, p4)) {
                        p = GraphicsUtil.createPoint(p3.getX(), p1.getY());
                        if (this.router.getCollision(p1, p) == null) {
                            this.getPoints().set(i + 1, p);
                            this.getPoints().remove(p2);
                            this.getPoints().remove(p3);
                            --i;
                            changed = true;
                        }
                    } else {
                        p = GraphicsUtil.createPoint(p3.getX(), p1.getY());
                        if (this.router.getCollision(p1, p) == null && this.router.getCollision(p, p3) == null) {
                            this.getPoints().set(i, p);
                            --i;
                            changed = true;
                        }
                    }
                }
            }
            p1 = p2;
            ++i;
        }
        p1 = this.getPoints().get(0);
        i = 1;
        while (i < this.getPoints().size() - 1) {
            p2 = this.getPoints().get(i);
            if (i + 1 < this.getPoints().size()) {
                p3 = this.getPoints().get(i + 1);
                if (p1.getX() == p2.getX() && p2.getX() == p3.getX()) {
                    if (p2.getY() < p1.getY() && p2.getY() < p3.getY() || p2.getY() > p1.getY() && p2.getY() > p3.getY()) {
                        this.getPoints().remove(p2);
                        --i;
                        changed = true;
                    }
                } else if (p1.getY() == p2.getY() && p2.getY() == p3.getY() && (p2.getX() < p1.getX() && p2.getX() < p3.getX() || p2.getX() > p1.getX() && p2.getX() > p3.getX())) {
                    this.getPoints().remove(p2);
                    --i;
                    changed = true;
                }
            }
            p1 = p2;
            ++i;
        }
        return changed;
    }

    public boolean optimize() {
        boolean changed = false;
        changed = this.removeUnusedPoints();
        if (this.removeUnusedSegments()) {
            this.removeUnusedPoints();
            changed = true;
        }
        return changed;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point> points) {
        this.points = points;
    }

    class Collision {
        Shape shape;
        Point start;
        Point end;

        public Collision(Shape shape, Point start, Point end) {
            this.shape = shape;
            this.start = start;
            this.end = end;
        }

        public String toString() {
            BaseElement o = BusinessObjectUtil.getFirstBaseElement((PictogramElement)this.shape);
            return ModelUtil.getTextValue(o);
        }
    }

    class Crossing {
        Connection connection;
        Point start;
        Point end;

        public Crossing(Connection connection, Point start, Point end) {
            this.connection = connection;
            this.start = start;
            this.end = end;
        }

        public String toString() {
            BaseElement o = BusinessObjectUtil.getFirstBaseElement((PictogramElement)this.connection);
            return ModelUtil.getTextValue(o);
        }
    }
}

