/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.adapters;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.bpel.model.BPELExtensibleElement;
import org.eclipse.bpel.model.adapters.AbstractStatefulAdapter;
import org.eclipse.bpel.validator.Activator;
import org.eclipse.bpel.validator.helpers.ModelQueryImpl;
import org.eclipse.bpel.validator.model.IModelQuery;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.RuleFactory;
import org.eclipse.bpel.validator.model.Validator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.w3c.dom.Element;

public class BasicAdapter
extends AbstractStatefulAdapter
implements INode {
    Validator mValidator = null;
    QName mNodeName = null;

    public Validator createValidator() {
        EObject obj = (EObject)this.getTarget();
        QName qname = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", obj.eClass().getName());
        return RuleFactory.INSTANCE.createValidator(qname);
    }

    @Override
    public List<INode> children() {
        EObject obj = (EObject)this.getTarget();
        EList childList = obj.eContents();
        ArrayList<INode> list = new ArrayList<INode>(childList.size());
        for (Object next : obj.eContents()) {
            INode node = this.adapt(next, INode.class);
            if (node == null) continue;
            list.add(node);
        }
        return list;
    }

    public String getAccessorMethodName(String propertyName) {
        return "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    Method methodFor(String name) {
        Class<?> clazz = this.getTarget().getClass();
        try {
            return clazz.getMethod(this.getAccessorMethodName(name), new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            Activator.log(nsme);
            return null;
        }
    }

    @Override
    public String getAttribute(QName name) {
        BPELExtensibleElement obj = (BPELExtensibleElement)this.getTarget(this.getTarget(), BPELExtensibleElement.class);
        Element element = obj.getElement();
        if (element != null && element.hasAttributeNS(name.getNamespaceURI(), name.getLocalPart())) {
            return element.getAttributeNS(name.getNamespaceURI(), name.getLocalPart());
        }
        Method method = this.methodFor(name.getLocalPart());
        if (method == null) {
            return null;
        }
        Object result = null;
        try {
            result = method.invoke((Object)this.getTarget(), new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return (String)result;
        }
        return null;
    }

    @Override
    public QName getAttributeAsQName(QName name) {
        String value = this.getAttribute(name);
        if (value == null) {
            return null;
        }
        return ModelQueryImpl.getModelQuery().createQName(this, value);
    }

    @Override
    public INode getNode(QName name) {
        Method method = this.methodFor(name.getLocalPart());
        if (method == null) {
            return null;
        }
        try {
            Object result = method.invoke((Object)this.getTarget(), new Object[0]);
            if (result != null) {
                return this.adapt(result, INode.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public List<INode> getNodeList(QName name) {
        Method method = this.methodFor(name.getLocalPart());
        if (method == null) {
            return null;
        }
        Object result = null;
        try {
            result = method.invoke((Object)this.getTarget(), new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null || !(result instanceof List)) {
            return Collections.emptyList();
        }
        List r = (List)result;
        if (r.size() == 0) {
            return Collections.emptyList();
        }
        LinkedList<INode> newList = new LinkedList<INode>();
        Iterator it = r.iterator();
        while (it.hasNext()) {
            newList.add(this.adapt(it.next(), INode.class));
        }
        return newList;
    }

    @Override
    public boolean isResolved() {
        EObject eObj = (EObject)this.getTarget();
        return !eObj.eIsProxy();
    }

    @Override
    public QName nodeName() {
        if (this.mNodeName != null) {
            return this.mNodeName;
        }
        EObject obj = (EObject)this.getTarget();
        String name = obj.eClass().getName();
        this.mNodeName = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1));
        return this.mNodeName;
    }

    @Override
    public Object nodeValue() {
        return this.getTarget();
    }

    @Override
    public Validator nodeValidator() {
        if (this.mValidator == null) {
            this.mValidator = this.createValidator();
            if (this.mValidator != null) {
                this.mValidator.setNode(this);
            }
        }
        return this.mValidator;
    }

    @Override
    public INode parentNode() {
        EObject obj = (EObject)this.getTarget();
        EObject parent = obj.eContainer();
        if (parent == null) {
            return null;
        }
        return this.adapt(parent, INode.class);
    }

    @Override
    public INode rootNode() {
        EObject obj = (EObject)this.getTarget();
        while (obj.eContainer() != null) {
            obj = obj.eContainer();
        }
        return this.adapt(obj, INode.class);
    }

    protected <T> T adapt(Object target, Class<T> type) {
        IModelQuery mq = ModelQueryImpl.getModelQuery();
        return mq.adapt(target, type, 0);
    }
}

