/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.assertj.core.api.AssertionErrorCollector;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.FieldValue;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.StubValue;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.SuperCall;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.SuperMethod;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.This;

public class ErrorCollector {
    public static final String FIELD_NAME = "errorCollector";
    private static final String INTERCEPT_METHOD_NAME = "intercept";
    private static final String CLASS_NAME = ErrorCollector.class.getName();
    private AssertionErrorCollector assertionErrorCollector;

    ErrorCollector(AssertionErrorCollector collector) {
        this.assertionErrorCollector = collector;
    }

    @RuntimeType
    public static Object intercept(@FieldValue(value="errorCollector") ErrorCollector errorCollector, @This Object assertion, @SuperCall Callable<?> proxy, @SuperMethod(nullIfImpossible=true) Method method, @StubValue Object stub) throws Exception {
        try {
            Object result = proxy.call();
            errorCollector.succeeded();
            return result;
        }
        catch (AssertionError assertionError) {
            if (ErrorCollector.isNestedErrorCollectorProxyCall()) {
                throw assertionError;
            }
            errorCollector.addError(assertionError);
            if (method != null && !method.getReturnType().isInstance(assertion)) {
                return stub;
            }
            return assertion;
        }
    }

    private void addError(AssertionError error) {
        this.assertionErrorCollector.collectAssertionError(error);
    }

    private void succeeded() {
        this.assertionErrorCollector.succeeded();
    }

    private static boolean isNestedErrorCollectorProxyCall() {
        return ErrorCollector.countErrorCollectorProxyCalls() > 1L;
    }

    private static long countErrorCollectorProxyCalls() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).filter(stackTraceElement -> CLASS_NAME.equals(stackTraceElement.getClassName()) && stackTraceElement.getMethodName().startsWith(INTERCEPT_METHOD_NAME)).count();
    }
}

