/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.folding;

import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.folding.FoldingMessages;

public class FoldingActionGroup
extends ActionGroup {
    private ProjectionViewer viewer;
    private final TextEditorAction toggle;
    private final TextOperationAction expand;
    private final TextOperationAction collapse;
    private final TextOperationAction expandAll;
    private final TextOperationAction collapseAll;
    private final IProjectionListener projectionListener;
    private final PreferenceAction restoreDefaults;

    public FoldingActionGroup(final ITextEditor editor, ITextViewer viewer) {
        if (!(viewer instanceof ProjectionViewer)) {
            this.toggle = null;
            this.expand = null;
            this.collapse = null;
            this.expandAll = null;
            this.collapseAll = null;
            this.restoreDefaults = null;
            this.projectionListener = null;
            return;
        }
        this.viewer = (ProjectionViewer)viewer;
        this.projectionListener = new IProjectionListener(){

            public void projectionEnabled() {
                FoldingActionGroup.this.update();
            }

            public void projectionDisabled() {
                FoldingActionGroup.this.update();
            }
        };
        this.viewer.addProjectionListener(this.projectionListener);
        this.toggle = this.createToggleFoldingAction(editor);
        this.toggle.setChecked(this.viewer.isProjectionMode());
        this.toggle.setActionDefinitionId("org.eclipse.ui.edit.text.folding.toggle");
        editor.setAction("FoldingToggle", (IAction)this.toggle);
        this.expandAll = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.ExpandAll.", editor, 20, true);
        this.expandAll.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand_all");
        editor.setAction("FoldingExpandAll", (IAction)this.expandAll);
        this.collapseAll = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.CollapseAll.", editor, 21, true);
        this.collapseAll.setActionDefinitionId("org.eclipse.ui.edit.text.folding.collapse_all");
        editor.setAction("FoldingCollapseAll", (IAction)this.collapseAll);
        this.expand = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.Expand.", editor, 17, true);
        this.expand.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand");
        editor.setAction("FoldingExpand", (IAction)this.expand);
        this.collapse = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.Collapse.", editor, 18, true);
        this.collapse.setActionDefinitionId("org.eclipse.ui.edit.text.folding.collapse");
        editor.setAction("FoldingCollapse", (IAction)this.collapse);
        this.restoreDefaults = new FoldingAction(this, FoldingMessages.getResourceBundle(), "Projection.Restore."){

            public void run() {
                if (editor instanceof XtextEditor) {
                    XtextEditor xtextEditor = (XtextEditor)editor;
                    xtextEditor.resetProjection();
                }
            }
        };
        this.restoreDefaults.setActionDefinitionId("org.eclipse.ui.edit.text.folding.restore");
        this.restoreDefaults.update();
        editor.setAction("FoldingRestore", (IAction)this.restoreDefaults);
    }

    protected TextEditorAction createToggleFoldingAction(ITextEditor editor) {
        return new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.Toggle.", editor, 19, true);
    }

    protected boolean isEnabled() {
        return this.viewer != null;
    }

    public void dispose() {
        if (this.isEnabled()) {
            this.viewer.removeProjectionListener(this.projectionListener);
            this.viewer = null;
        }
        super.dispose();
    }

    protected void update() {
        if (this.isEnabled()) {
            this.toggle.update();
            this.toggle.setChecked(this.viewer.isProjectionMode());
            this.expand.update();
            this.expandAll.update();
            this.collapse.update();
            this.collapseAll.update();
            this.restoreDefaults.update();
        }
    }

    public void fillMenu(IMenuManager manager) {
        if (this.isEnabled()) {
            this.update();
            manager.add((IAction)this.toggle);
            manager.add((IAction)this.expandAll);
            manager.add((IAction)this.expand);
            manager.add((IAction)this.collapse);
            manager.add((IAction)this.collapseAll);
            manager.add((IAction)this.restoreDefaults);
        }
    }

    public void updateActionBars() {
        this.update();
    }

    private class FoldingAction
    extends PreferenceAction {
        FoldingAction(ResourceBundle bundle, String prefix) {
            super(bundle, prefix, 1);
        }

        public void update() {
            this.setEnabled(FoldingActionGroup.this.isEnabled() && FoldingActionGroup.this.viewer.isProjectionMode());
        }
    }

    private static abstract class PreferenceAction
    extends ResourceAction
    implements IUpdate {
        PreferenceAction(ResourceBundle bundle, String prefix, int style) {
            super(bundle, prefix, style);
        }
    }
}

