/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend.typesystem.xsd.XSDMetaModel;
import org.eclipse.xtend.typesystem.xsd.builder.XSDManager;
import org.eclipse.xtend.typesystem.xsd.ui.XSDToolsPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDMetamodelStore {
    private XSDManager manager = XSDManager.Util.createManager();
    private HashMap<IProject, XSDManager> views = new HashMap();

    private void collectReferencingProjects(IProject proj, Set<IProject> refs) throws CoreException {
        refs.add(proj);
        IProject[] iProjectArray = proj.getReferencedProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (!refs.contains(p)) {
                this.collectReferencingProjects(p, refs);
            }
            ++n2;
        }
    }

    public Collection<MetaModel> getMetamodels(IProject proj) {
        try {
            ArrayList<MetaModel> result = new ArrayList<MetaModel>();
            HashSet<IProject> refs = new HashSet<IProject>();
            this.collectReferencingProjects(proj, refs);
            for (IProject p : refs) {
                XSDManager man = this.getXSDManager(p);
                if (man == null) continue;
                result.add((MetaModel)new XSDMetaModel(man));
            }
            return result;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public XSDManager getXSDManager(IProject project) {
        if (!XSDToolsPlugin.isXSDProject(project)) {
            return null;
        }
        XSDManager m = this.views.get(project);
        if (m == null) {
            m = XSDManager.Util.createView(this.manager);
            this.views.put(project, m);
        }
        return m;
    }
}

