/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.mapping.DelegatingStorageMerger;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.mapping.IStorageMerger;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.MergeStatus;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.core.subscribers.SubscriberDiffTreeEventHandler;

public abstract class CVSSubscriberMergeContext
extends SubscriberMergeContext {
    private static final IStorageMerger MERGER = new DelegatingStorageMerger(){

        protected IStorageMerger createDelegateMerger(IStorage target) throws CoreException {
            IFile file;
            IStorageMerger storageMerger = super.createDelegateMerger(target);
            if (storageMerger == null && target instanceof IFile && this.isText(file = (IFile)target)) {
                storageMerger = 1.createTextMerger();
            }
            return storageMerger;
        }

        protected int getType(IStorage target) {
            if (target instanceof IFile) {
                IFile file = (IFile)target;
                if (this.isText(file)) {
                    return 1;
                }
                return 2;
            }
            return super.getType(target);
        }

        private boolean isText(IFile file) {
            try {
                ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)file);
                byte[] syncBytes = cvsFile.getSyncBytes();
                if (syncBytes != null) {
                    return !ResourceSyncInfo.isBinary((byte[])syncBytes);
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
            return false;
        }
    };

    protected CVSSubscriberMergeContext(Subscriber subscriber, ISynchronizationScopeManager manager) {
        super(subscriber, manager);
    }

    public void run(IWorkspaceRunnable runnable, ISchedulingRule rule, int flags, IProgressMonitor monitor) throws CoreException {
        super.run(monitor1 -> EclipseSynchronizer.getInstance().run(rule, monitor2 -> {
            try {
                runnable.run(monitor2);
            }
            catch (CoreException e) {
                throw CVSException.wrapException((CoreException)e);
            }
        }, monitor1), rule, flags, monitor);
    }

    public ISchedulingRule getMergeRule(IDiff node) {
        return this.getDiffTree().getResource(node).getProject();
    }

    protected void makeInSync(IDiff diff, IProgressMonitor monitor) throws CoreException {
        this.markAsMerged(diff, true, monitor);
    }

    public void reject(IDiff diff, IProgressMonitor monitor) throws CoreException {
        this.markAsMerged(diff, false, monitor);
    }

    public IStatus merge(IDiff[] diffs, boolean ignoreLocalChanges, IProgressMonitor monitor) throws CoreException {
        IStatus[] result = new IStatus[]{Status.OK_STATUS};
        if (diffs.length > 0) {
            this.run(monitor1 -> {
                IStatus iStatus = this.internalMerge(diffs, ignoreLocalChanges, monitor1);
            }, this.getMergeRule(diffs), 1, monitor);
        }
        return result[0];
    }

    private IStatus internalMerge(IDiff[] diffs, boolean ignoreLocalChanges, IProgressMonitor monitor) throws CoreException {
        IResource resource;
        ArrayList<IDiff> fileChanges = new ArrayList<IDiff>();
        ArrayList<IDiff> folderDiffs = new ArrayList<IDiff>();
        ArrayList<IDiff> fileDeletions = new ArrayList<IDiff>();
        IDiff[] iDiffArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            IDiff diff = iDiffArray[n2];
            resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            if (resource.getType() == 1) {
                if (this.isIncomingDeletion(diff, ignoreLocalChanges)) {
                    fileDeletions.add(diff);
                } else {
                    fileChanges.add(diff);
                }
            } else {
                folderDiffs.add(diff);
            }
            ++n2;
        }
        if (fileDeletions.isEmpty() && fileChanges.isEmpty() && folderDiffs.isEmpty()) {
            return Status.OK_STATUS;
        }
        int ticks = (fileDeletions.size() + fileChanges.size()) * 100;
        try {
            IStatus status;
            monitor.beginTask(null, ticks);
            ArrayList<IStatus> result = new ArrayList<IStatus>();
            if (!fileDeletions.isEmpty() && !(status = CVSSubscriberMergeContext.super.merge(fileDeletions.toArray(new IDiff[fileDeletions.size()]), ignoreLocalChanges, Policy.subMonitorFor(monitor, 100 * fileDeletions.size()))).isOK()) {
                if (status.isMultiStatus()) {
                    result.addAll(Arrays.asList(status.getChildren()));
                } else {
                    result.add(status);
                }
            }
            if (!fileChanges.isEmpty() && !(status = CVSSubscriberMergeContext.super.merge(fileChanges.toArray(new IDiff[fileChanges.size()]), ignoreLocalChanges, Policy.subMonitorFor(monitor, 100 * fileChanges.size()))).isOK()) {
                if (status.isMultiStatus()) {
                    result.addAll(Arrays.asList(status.getChildren()));
                } else {
                    result.add(status);
                }
            }
            if (!folderDiffs.isEmpty()) {
                Collections.sort(folderDiffs, (o1, o2) -> o2.getPath().toString().compareTo(o1.getPath().toString()));
                for (IDiff diff : folderDiffs) {
                    resource = ResourceDiffTree.getResourceFor((IDiff)diff);
                    IDiff currentDiff = this.getSubscriber().getDiff(resource);
                    this.merge(currentDiff, ignoreLocalChanges, monitor);
                }
            }
            if (result.isEmpty()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (result.size() == 1) {
                IStatus iStatus = (IStatus)result.get(0);
                return iStatus;
            }
            MergeStatus mergeStatus = new MergeStatus("org.eclipse.team.cvs.ui", ((IStatus)result.get(0)).getMessage(), this.getFailedFiles(result));
            return mergeStatus;
        }
        finally {
            monitor.done();
        }
    }

    private boolean isIncomingDeletion(IDiff diff, boolean ignoreLocalChanges) {
        if (diff instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)diff;
            if (twd.getKind() == 2 && twd.getDirection() == 512) {
                return true;
            }
            ITwoWayDiff remoteChange = twd.getRemoteChange();
            if (ignoreLocalChanges && remoteChange != null) {
                return this.isIncomingDeletion((IDiff)remoteChange, ignoreLocalChanges);
            }
            ITwoWayDiff localChange = twd.getLocalChange();
            if (ignoreLocalChanges && localChange != null) {
                return this.isIncomingDeletion((IDiff)localChange, ignoreLocalChanges);
            }
            return false;
        }
        if (diff instanceof IResourceDiff) {
            IResourceDiff rd = (IResourceDiff)diff;
            return (ignoreLocalChanges || this.getMergeType() == 2) && rd.getAfterState() == null;
        }
        return false;
    }

    private IFile[] getFailedFiles(List result) {
        ArrayList<IFile> failures = new ArrayList<IFile>();
        for (IStatus status : result) {
            if (!(status instanceof MergeStatus)) continue;
            MergeStatus ms = (MergeStatus)status;
            failures.addAll(Arrays.asList(ms.getConflictingFiles()));
        }
        return failures.toArray(new IFile[failures.size()]);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IStorageMerger.class) {
            return adapter.cast(MERGER);
        }
        return (T)super.getAdapter(adapter);
    }

    protected SubscriberDiffTreeEventHandler getHandler() {
        SubscriberDiffTreeEventHandler o = this.getAdapter(SubscriberDiffTreeEventHandler.class);
        if (o instanceof SubscriberDiffTreeEventHandler) {
            return o;
        }
        return null;
    }
}

