/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.history.FileRevisionEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class ResourceEditionNode
implements IStructureComparator,
ITypedElement,
IEncodedStreamContentAccessor,
IAdaptable {
    private ICVSRemoteResource resource;
    private ResourceEditionNode[] children;
    private ISharedDocumentAdapter sharedDocumentAdapter;
    private IEditorInput editorInput;

    public ResourceEditionNode(ICVSRemoteResource resourceEdition) {
        this.resource = resourceEdition;
    }

    public boolean equals(Object other) {
        if (other instanceof ITypedElement) {
            String otherName = ((ITypedElement)other).getName();
            return this.getName().equals(otherName);
        }
        return super.equals(other);
    }

    public Object[] getChildren() {
        block5: {
            if (this.children == null) {
                this.children = new ResourceEditionNode[0];
                if (this.resource != null) {
                    try {
                        CVSUIPlugin.runWithProgress(null, true, monitor -> {
                            try {
                                ICVSRemoteResource[] members = this.resource.members(monitor);
                                this.children = new ResourceEditionNode[members.length];
                                int i = 0;
                                while (i < members.length) {
                                    this.children[i] = new ResourceEditionNode(members[i]);
                                    ++i;
                                }
                            }
                            catch (TeamException e) {
                                throw new InvocationTargetException(e);
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        if (!(t instanceof TeamException)) break block5;
                        CVSUIPlugin.log((CoreException)((Object)((TeamException)t)));
                    }
                }
            }
        }
        return this.children;
    }

    public InputStream getContents() throws CoreException {
        IStorage storage = this.getStorage();
        if (storage != null) {
            return storage.getContents();
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    public Image getImage() {
        return CompareUI.getImage((IAdaptable)this.resource);
    }

    public String getName() {
        return this.resource == null ? "" : this.resource.getName();
    }

    public ICVSRemoteResource getRemoteResource() {
        return this.resource;
    }

    public String getType() {
        if (this.resource == null) {
            return "???";
        }
        if (this.resource.isContainer()) {
            return "FOLDER";
        }
        String name = this.resource.getName();
        return (name = name.substring(name.lastIndexOf(46) + 1)).length() == 0 ? "???" : name;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getCharset() throws CoreException {
        String charset;
        IResource local = this.resource.getIResource();
        if (local != null && local.getType() == 1) {
            return ((IFile)local).getCharset();
        }
        IStorage storage = this.getStorage();
        if (storage instanceof IEncodedStorage && (charset = ((IEncodedStorage)storage).getCharset()) != null) {
            return charset;
        }
        return null;
    }

    private IStorage getStorage() throws TeamException {
        if (this.resource == null) {
            return null;
        }
        IStorage[] holder = new IStorage[1];
        try {
            CVSUIPlugin.runWithProgress(null, true, monitor -> {
                try {
                    iStorageArray[0] = ((IResourceVariant)this.resource).getStorage(monitor);
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            throw TeamException.asTeamException((InvocationTargetException)e);
        }
        catch (InterruptedException interruptedException) {}
        return holder[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ISharedDocumentAdapter.class) {
            ResourceEditionNode resourceEditionNode = this;
            synchronized (resourceEditionNode) {
                if (this.sharedDocumentAdapter == null) {
                    this.sharedDocumentAdapter = new SharedDocumentAdapter(){

                        public IEditorInput getDocumentKey(Object element) {
                            return ResourceEditionNode.this.getDocumentKey(element);
                        }

                        public void flushDocument(IDocumentProvider provider, IEditorInput documentKey, IDocument document, boolean overwrite) throws CoreException {
                        }
                    };
                }
                return adapter.cast(this.sharedDocumentAdapter);
            }
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    private IEditorInput getDocumentKey(Object element) {
        try {
            if (element == this && this.getStorage() != null) {
                if (this.editorInput == null) {
                    this.editorInput = new FileRevisionEditorInput(this.resource.getAdapter(IFileRevision.class), this.getStorage());
                }
                return this.editorInput;
            }
        }
        catch (TeamException e) {
            TeamUIPlugin.log((CoreException)((Object)e));
        }
        return null;
    }
}

