/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.VersionCollator;

public class HistoryTableProvider {
    private ICVSFile currentFile;
    private String currentRevision;
    private TableViewer viewer;
    private Font currentRevisionFont;
    private static final int COL_REVISION = 0;
    private static final int COL_BRANCHES = 1;
    private static final int COL_TAGS = 2;
    private static final int COL_DATE = 3;
    private static final int COL_AUTHOR = 4;
    private static final int COL_COMMENT = 5;

    protected ILogEntry adaptToLogEntry(Object element) {
        ILogEntry entry = null;
        if (element instanceof ILogEntry) {
            entry = (ILogEntry)element;
        } else if (element instanceof IAdaptable) {
            entry = (ILogEntry)((IAdaptable)element).getAdapter(ILogEntry.class);
        }
        return entry;
    }

    public TableViewer createTable(Composite parent) {
        Table table = new Table(parent, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        TableViewer viewer = new TableViewer(table);
        this.createColumns(table, layout, viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new HistoryLabelProvider());
        HistoryComparator sorter = new HistoryComparator(0);
        sorter.setReversed(true);
        viewer.setComparator((ViewerComparator)sorter);
        table.addDisposeListener(e -> {
            if (this.currentRevisionFont != null) {
                this.currentRevisionFont.dispose();
            }
        });
        this.viewer = viewer;
        return viewer;
    }

    public CheckboxTableViewer createCheckBoxTable(Composite parent) {
        Table table = new Table(parent, 66336);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        CheckboxTableViewer viewer = new CheckboxTableViewer(table);
        this.createColumns(table, layout, (TableViewer)viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new HistoryLabelProvider());
        HistoryComparator sorter = new HistoryComparator(0);
        sorter.setReversed(true);
        viewer.setComparator((ViewerComparator)sorter);
        table.addDisposeListener(e -> {
            if (this.currentRevisionFont != null) {
                this.currentRevisionFont.dispose();
            }
        });
        this.viewer = viewer;
        return viewer;
    }

    private void createColumns(Table table, TableLayout layout, TableViewer viewer) {
        SelectionListener headerListener = this.getColumnListener(viewer);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(CVSUIMessages.HistoryView_revision);
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(CVSUIMessages.HistoryView_branches);
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(CVSUIMessages.HistoryView_tags);
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(CVSUIMessages.HistoryView_date);
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(CVSUIMessages.HistoryView_author);
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(CVSUIMessages.HistoryView_comment);
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
    }

    private SelectionListener getColumnListener(final TableViewer tableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = tableViewer.getTable().indexOf((TableColumn)e.widget);
                HistoryComparator oldSorter = (HistoryComparator)tableViewer.getComparator();
                if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    tableViewer.refresh();
                } else {
                    tableViewer.setComparator((ViewerComparator)new HistoryComparator(column));
                }
            }
        };
    }

    public String getCurrentRevision() {
        return this.currentRevision;
    }

    private String getRevision(ICVSFile currentEdition) throws CVSException {
        if (currentEdition == null) {
            return "";
        }
        ResourceSyncInfo info = currentEdition.getSyncInfo();
        if (info == null) {
            return "";
        }
        return info.getRevision();
    }

    public void setFile(ICVSFile file) throws CVSException {
        this.currentFile = file;
        this.currentRevision = this.getRevision(this.currentFile);
    }

    public ICVSFile getICVSFile() {
        return this.currentFile;
    }

    class HistoryComparator
    extends ViewerComparator {
        private boolean reversed = false;
        private int columnNumber;
        private VersionCollator versionCollator = new VersionCollator();
        private int[][] SORT_ORDERS_BY_COLUMN;

        public HistoryComparator(int columnNumber) {
            int[][] nArrayArray = new int[6][];
            int[] nArray = new int[6];
            nArray[1] = 3;
            nArray[2] = 4;
            nArray[3] = 5;
            nArray[4] = 2;
            nArray[5] = 1;
            nArrayArray[0] = nArray;
            int[] nArray2 = new int[6];
            nArray2[0] = 1;
            nArray2[2] = 3;
            nArray2[3] = 4;
            nArray2[4] = 5;
            nArray2[5] = 2;
            nArrayArray[1] = nArray2;
            int[] nArray3 = new int[6];
            nArray3[0] = 2;
            nArray3[2] = 3;
            nArray3[3] = 4;
            nArray3[4] = 5;
            nArray3[5] = 1;
            nArrayArray[2] = nArray3;
            int[] nArray4 = new int[6];
            nArray4[0] = 3;
            nArray4[2] = 4;
            nArray4[3] = 5;
            nArray4[4] = 2;
            nArray4[5] = 1;
            nArrayArray[3] = nArray4;
            int[] nArray5 = new int[6];
            nArray5[0] = 4;
            nArray5[2] = 3;
            nArray5[3] = 5;
            nArray5[4] = 2;
            nArray5[5] = 1;
            nArrayArray[4] = nArray5;
            int[] nArray6 = new int[6];
            nArray6[0] = 5;
            nArray6[2] = 3;
            nArray6[3] = 4;
            nArray6[4] = 2;
            nArray6[5] = 1;
            nArrayArray[5] = nArray6;
            this.SORT_ORDERS_BY_COLUMN = nArrayArray;
            this.columnNumber = columnNumber;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            ILogEntry e1 = HistoryTableProvider.this.adaptToLogEntry(o1);
            ILogEntry e2 = HistoryTableProvider.this.adaptToLogEntry(o2);
            int result = 0;
            if (e1 == null || e2 == null) {
                result = super.compare(viewer, o1, o2);
            } else {
                int[] columnSortOrder = this.SORT_ORDERS_BY_COLUMN[this.columnNumber];
                int i = 0;
                while (i < columnSortOrder.length) {
                    result = this.compareColumnValue(columnSortOrder[i], e1, e2);
                    if (result != 0) break;
                    ++i;
                }
            }
            if (this.reversed) {
                result = -result;
            }
            return result;
        }

        int compareColumnValue(int columnNumber, ILogEntry e1, ILogEntry e2) {
            switch (columnNumber) {
                case 0: {
                    return this.versionCollator.compare(e1.getRevision(), e2.getRevision());
                }
                case 1: {
                    CVSTag[] branches1 = e1.getBranches();
                    CVSTag[] branches2 = e2.getBranches();
                    if (branches2.length == 0) {
                        return -1;
                    }
                    if (branches1.length == 0) {
                        return 1;
                    }
                    return this.getComparator().compare(branches1[0].getName(), branches2[0].getName());
                }
                case 2: {
                    CVSTag[] tags1 = e1.getTags();
                    CVSTag[] tags2 = e2.getTags();
                    if (tags2.length == 0) {
                        return -1;
                    }
                    if (tags1.length == 0) {
                        return 1;
                    }
                    return this.getComparator().compare(tags1[0].getName(), tags2[0].getName());
                }
                case 3: {
                    Date date1 = e1.getDate();
                    Date date2 = e2.getDate();
                    return date1.compareTo(date2);
                }
                case 4: {
                    return this.getComparator().compare(e1.getAuthor(), e2.getAuthor());
                }
                case 5: {
                    return this.getComparator().compare(e1.getComment(), e2.getComment());
                }
            }
            return 0;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public void setReversed(boolean newReversed) {
            this.reversed = newReversed;
        }
    }

    class HistoryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider,
    IFontProvider {
        private DateFormat dateFormat;

        HistoryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ILogEntry entry = HistoryTableProvider.this.adaptToLogEntry(element);
            if (entry == null) {
                return "";
            }
            switch (columnIndex) {
                case 0: {
                    String revision = entry.getRevision();
                    String currentRevision = HistoryTableProvider.this.getCurrentRevision();
                    if (currentRevision != null && currentRevision.equals(revision)) {
                        revision = NLS.bind((String)CVSUIMessages.currentRevision, (Object[])new String[]{revision});
                    }
                    return revision;
                }
                case 1: {
                    CVSTag[] branches = entry.getBranches();
                    StringBuilder result = new StringBuilder();
                    int i = 0;
                    while (i < branches.length) {
                        result.append(branches[i].getName());
                        if (i < branches.length - 1) {
                            result.append(", ");
                        }
                        ++i;
                    }
                    return result.toString();
                }
                case 2: {
                    CVSTag[] tags = entry.getTags();
                    StringBuilder result = new StringBuilder();
                    int i = 0;
                    while (i < tags.length) {
                        result.append(tags[i].getName());
                        if (i < tags.length - 1) {
                            result.append(", ");
                        }
                        ++i;
                    }
                    return result.toString();
                }
                case 3: {
                    Date date = entry.getDate();
                    if (date == null) {
                        return CVSUIMessages.notAvailable;
                    }
                    return this.getDateFormat().format(date);
                }
                case 4: {
                    return entry.getAuthor();
                }
                case 5: {
                    String comment = entry.getComment();
                    int index = comment.indexOf("\n");
                    switch (index) {
                        case -1: {
                            return comment;
                        }
                        case 0: {
                            return CVSUIMessages.HistoryView_______4;
                        }
                    }
                    return NLS.bind((String)CVSUIMessages.CVSCompareRevisionsInput_truncate, (Object[])new String[]{comment.substring(0, index)});
                }
            }
            return "";
        }

        private synchronized DateFormat getDateFormat() {
            if (this.dateFormat == null) {
                this.dateFormat = DateFormat.getInstance();
            }
            return this.dateFormat;
        }

        public Color getForeground(Object element) {
            ILogEntry entry = HistoryTableProvider.this.adaptToLogEntry(element);
            if (entry.isDeletion()) {
                return Display.getCurrent().getSystemColor(18);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Font getFont(Object element) {
            ILogEntry entry = HistoryTableProvider.this.adaptToLogEntry(element);
            if (entry == null) {
                return null;
            }
            String revision = entry.getRevision();
            String currentRevision = HistoryTableProvider.this.getCurrentRevision();
            if (currentRevision != null && currentRevision.equals(revision)) {
                if (HistoryTableProvider.this.currentRevisionFont == null) {
                    FontData[] data;
                    Font defaultFont = JFaceResources.getDefaultFont();
                    FontData[] fontDataArray = data = defaultFont.getFontData();
                    int n = data.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FontData d = fontDataArray[n2];
                        d.setStyle(1);
                        ++n2;
                    }
                    HistoryTableProvider.this.currentRevisionFont = new Font((Device)HistoryTableProvider.this.viewer.getTable().getDisplay(), data);
                }
                return HistoryTableProvider.this.currentRevisionFont;
            }
            return null;
        }
    }
}

