/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.internal.converter;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import org.eclipse.eef.EEFPageDescription;
import org.eclipse.eef.EEFSemanticValidationRuleDescription;
import org.eclipse.eef.EEFToolbarAction;
import org.eclipse.eef.EefFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.core.api.AbstractDescriptionConverter;
import org.eclipse.sirius.properties.core.api.TransformationCache;
import org.eclipse.sirius.properties.core.internal.Messages;

public class PageDescriptionConverter
extends AbstractDescriptionConverter {
    @Override
    public boolean canHandle(EObject description) {
        return description instanceof PageDescription;
    }

    @Override
    public EObject convert(EObject description, Map<String, Object> parameters, TransformationCache cache) {
        if (description instanceof PageDescription) {
            PageDescription pageDescription = (PageDescription)description;
            EEFPageDescription page = EefFactory.eINSTANCE.createEEFPageDescription();
            page.setIdentifier(pageDescription.getName());
            page.setLabelExpression(pageDescription.getLabelExpression());
            page.setDomainClass(pageDescription.getDomainClass());
            page.setSemanticCandidateExpression(pageDescription.getSemanticCandidateExpression());
            page.setPreconditionExpression(pageDescription.getPreconditionExpression());
            page.setIndented(pageDescription.isIndented());
            if (page.getIdentifier() == null || page.getIdentifier().trim().length() == 0) {
                page.setIdentifier(EcoreUtil.getURI((EObject)pageDescription).toString());
            }
            cache.put(description, page);
            if (pageDescription.getValidationSet() != null) {
                EList semanticValidationRules = pageDescription.getValidationSet().getSemanticValidationRules();
                page.getSemanticValidationRules().addAll(this.convertCollection((Collection<?>)semanticValidationRules, parameters, cache, EEFSemanticValidationRuleDescription.class));
            }
            page.getActions().addAll(this.convertCollection((Collection<?>)pageDescription.getActions(), parameters, cache, EEFToolbarAction.class));
            return page;
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.IDescriptionConverter_InvalidDescriptionType, description.getClass().getName(), PageDescription.class.getName()));
    }
}

