/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.derived;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.sdk.s2e.environment.AbstractJob;

public class DefaultResourceChangeEventFilter
implements Predicate<IResourceChangeEvent> {
    public static final String GIT_UPDATES = "org.eclipse.egit.";
    public static final String MAVEN_UPDATES = "org.eclipse.m2e.";
    public static final String SONAR_UPDATE = "org.sonarlint.";
    public static final String WEB_TOOLS_UPDATE = "org.eclipse.wst.";
    public static final String DEBUG_EVENT = "org.eclipse.debug.";
    public static final String JDT_DEBUG_EVENT = "org.eclipse.jdt.internal.debug.";
    public static final String ANNOTATION_PROCESSING_JOB = "org.eclipse.core.internal.events.NotificationManager.NotifyJob";
    public static final String ANOTATION_PROCESSING_BUILD = "org.eclipse.core.internal.events.AutoBuildJob";
    public static final String EXTERNAL_FOLDER_UPDATE = "org.eclipse.jdt.internal.core.ExternalFoldersManager.RefreshJob";
    public static final String DEBUG_INIT = "org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager.InitJob";
    public static final String REFRESH_JOB = "org.eclipse.core.internal.refresh.RefreshJob";
    public static final String WORKSPACE_INIT_JOB = "org.eclipse.jdt.internal.ui.InitializeAfterLoadJob.RealJob";
    public static final String TEAM_UPDATES = "org.eclipse.team.";
    public static final String SEARCH = "org.eclipse.search2.";
    public static final String MARKER_UPDATE = "org.eclipse.ui.internal.views.markers.";
    public static final String JAVA_INDEX_UPDATE_JOB_NAME = "Updating Java index";
    private final Collection<String> m_excludedJobClassNamePrefixes;
    private final Collection<String> m_excludedJobNames;
    private boolean m_isIgnoreBuildEvents;
    private boolean m_isIgnoreScoutSdkEvents;

    public DefaultResourceChangeEventFilter() {
        String[] defaultJobExclusionsFqn = new String[]{GIT_UPDATES, MAVEN_UPDATES, SONAR_UPDATE, WEB_TOOLS_UPDATE, DEBUG_EVENT, JDT_DEBUG_EVENT, ANNOTATION_PROCESSING_JOB, ANOTATION_PROCESSING_BUILD, EXTERNAL_FOLDER_UPDATE, DEBUG_INIT, REFRESH_JOB, WORKSPACE_INIT_JOB, TEAM_UPDATES, SEARCH, MARKER_UPDATE};
        this.m_excludedJobClassNamePrefixes = new ArrayList<String>(defaultJobExclusionsFqn.length);
        Collections.addAll(this.m_excludedJobClassNamePrefixes, defaultJobExclusionsFqn);
        this.m_excludedJobNames = new ArrayList<String>(1);
        this.m_excludedJobNames.add(JAVA_INDEX_UPDATE_JOB_NAME);
        this.m_isIgnoreBuildEvents = true;
        this.m_isIgnoreScoutSdkEvents = true;
    }

    @Override
    public boolean test(IResourceChangeEvent event) {
        if (event == null) {
            return false;
        }
        boolean ignoreBuildEvents = this.isIgnoreBuildEvents();
        if (ignoreBuildEvents && event.getBuildKind() != 0) {
            return false;
        }
        Job curJob = Job.getJobManager().currentJob();
        if (curJob == null) {
            return false;
        }
        if (this.isIgnoreScoutSdkEvents() && curJob instanceof AbstractJob) {
            return false;
        }
        if (ignoreBuildEvents && (curJob.belongsTo(ResourcesPlugin.FAMILY_AUTO_BUILD) || curJob.belongsTo(ResourcesPlugin.FAMILY_MANUAL_BUILD))) {
            return false;
        }
        String jobFqn = curJob.getClass().getName().replace('$', '.');
        String jobName = curJob.getName();
        Predicate<String> excludedClassNamePrefixes = className -> this.getExcludedJobClassNamePrefixes().stream().anyMatch(className::startsWith);
        Predicate<String> excludedJobNames = name -> this.getExcludedJobNames().stream().anyMatch(name::equals);
        if ("org.eclipse.core.internal.jobs.ThreadJob".equals(jobFqn)) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            return Arrays.stream(stackTrace).map(StackTraceElement::getClassName).noneMatch(excludedClassNamePrefixes);
        }
        if (jobFqn.startsWith("org.eclipse.core.runtime.jobs.Job.")) {
            return !excludedJobNames.test(jobName);
        }
        return !excludedClassNamePrefixes.test(jobFqn) && !excludedJobNames.test(jobName);
    }

    public boolean isIgnoreBuildEvents() {
        return this.m_isIgnoreBuildEvents;
    }

    public void setIgnoreBuildEvents(boolean isIgnoreBuildEvents) {
        this.m_isIgnoreBuildEvents = isIgnoreBuildEvents;
    }

    public boolean isIgnoreScoutSdkEvents() {
        return this.m_isIgnoreScoutSdkEvents;
    }

    public void setIgnoreScoutSdkEvents(boolean isIgnoreScoutSdkEvents) {
        this.m_isIgnoreScoutSdkEvents = isIgnoreScoutSdkEvents;
    }

    public Collection<String> getExcludedJobClassNamePrefixes() {
        return this.m_excludedJobClassNamePrefixes;
    }

    public void setExcludedJobClassNamePrefixes(Collection<String> excludedJobClassNamePrefixes) {
        this.m_excludedJobClassNamePrefixes.clear();
        if (excludedJobClassNamePrefixes != null) {
            this.m_excludedJobClassNamePrefixes.addAll(excludedJobClassNamePrefixes);
        }
    }

    public Collection<String> getExcludedJobNames() {
        return this.m_excludedJobNames;
    }

    public void setExcludedJobNames(Collection<String> excludedJobNames) {
        this.m_excludedJobNames.clear();
        if (excludedJobNames != null) {
            this.m_excludedJobNames.addAll(excludedJobNames);
        }
    }
}

