/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.telnet.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.remote.core.IRemoteCommandShellService;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteConnectionControlService;
import org.eclipse.remote.core.IRemoteConnectionHostService;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.RemoteConnectionChangeEvent;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.telnet.core.TelnetCommandShell;

public class TelnetConnection
implements IRemoteConnectionControlService,
IRemoteCommandShellService,
IRemoteConnectionHostService,
IRemoteConnectionChangeListener {
    public static int DEFAULT_PORT = 23;
    public static int DEFAULT_TIMEOUT = 0;
    public static final String HOSTNAME_ATTR = "telnet.hostname.attr";
    public static final String USERNAME_ATTR = "telnet.username.attr";
    public static final String PASSWORD_ATTR = "telnet.password.attr";
    public static final String PORT_ATTR = "telnet.port.attr";
    public static final String TIMEOUT_ATTR = "telnet.timeout.attr";
    private final IRemoteConnection remoteConnection;
    private final List<TelnetCommandShell> shells = Collections.synchronizedList(new ArrayList());
    private boolean isOpen;

    private TelnetConnection(IRemoteConnection remoteConnection) {
        this.remoteConnection = remoteConnection;
        remoteConnection.addConnectionChangeListener((IRemoteConnectionChangeListener)this);
    }

    public IRemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    public IRemoteProcess getCommandShell(int flags) throws IOException {
        if (this.isOpen) {
            TelnetCommandShell shell = new TelnetCommandShell(this.remoteConnection, this);
            try {
                shell.connect();
            }
            catch (RemoteConnectionException e) {
                throw new IOException(e.getMessage());
            }
            this.shells.add(shell);
            return shell;
        }
        return null;
    }

    public int getPort() {
        try {
            String portStr = this.remoteConnection.getAttribute(PORT_ATTR);
            return !portStr.isEmpty() ? Integer.parseInt(portStr) : DEFAULT_PORT;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public int getTimeout() {
        try {
            String timeoutStr = this.remoteConnection.getAttribute(TIMEOUT_ATTR);
            return !timeoutStr.isEmpty() ? Integer.parseInt(timeoutStr) : DEFAULT_TIMEOUT;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<TelnetCommandShell> list = this.shells;
        synchronized (list) {
            for (TelnetCommandShell shell : this.shells) {
                shell.destroy();
            }
        }
        this.isOpen = false;
    }

    public String getHostname() {
        return this.remoteConnection.getAttribute(HOSTNAME_ATTR);
    }

    public boolean useLoginShell() {
        return true;
    }

    public String getUsername() {
        return this.remoteConnection.getAttribute(USERNAME_ATTR);
    }

    public void setHostname(String hostname) {
        if (this.remoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.remoteConnection;
            wc.setAttribute(HOSTNAME_ATTR, hostname);
        }
    }

    public void setPassphrase(String passphrase) {
    }

    public void setPassword(String password) {
        if (this.remoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.remoteConnection;
            wc.setSecureAttribute(PASSWORD_ATTR, password);
        }
    }

    public void setPort(int port) {
        if (this.remoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.remoteConnection;
            wc.setAttribute(PORT_ATTR, Integer.toString(port));
        }
    }

    public void setTimeout(int timeout) {
        if (this.remoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.remoteConnection;
            wc.setAttribute(TIMEOUT_ATTR, Integer.toString(timeout));
        }
    }

    public void setUseLoginShell(boolean useLogingShell) {
    }

    public void setUsePassword(boolean usePassword) {
    }

    public void setUsername(String username) {
        if (this.remoteConnection instanceof IRemoteConnectionWorkingCopy) {
            IRemoteConnectionWorkingCopy wc = (IRemoteConnectionWorkingCopy)this.remoteConnection;
            wc.setAttribute(USERNAME_ATTR, username);
        }
    }

    public void open(IProgressMonitor monitor) throws RemoteConnectionException {
        this.isOpen = true;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void connectionChanged(RemoteConnectionChangeEvent event) {
        switch (event.getType()) {
            case 2: {
                this.isOpen = true;
                break;
            }
            case 1: 
            case 4: {
                this.isOpen = false;
            }
        }
    }

    protected void terminated(TelnetCommandShell shell) {
        this.shells.remove(shell);
    }

    public String getPassphrase() {
        return "";
    }

    public String getPassword() {
        return this.remoteConnection.getSecureAttribute(PASSWORD_ATTR);
    }

    public boolean usePassword() {
        return true;
    }

    /* synthetic */ TelnetConnection(IRemoteConnection iRemoteConnection, TelnetConnection telnetConnection) {
        this(iRemoteConnection);
    }

    public static class Factory
    implements IRemoteConnection.Service.Factory {
        public <T extends IRemoteConnection.Service> T getService(IRemoteConnection remoteConnection, Class<T> service) {
            if (TelnetConnection.class.equals(service)) {
                return (T)new TelnetConnection(remoteConnection, null);
            }
            if (IRemoteConnectionControlService.class.equals(service) || IRemoteConnectionHostService.class.equals(service) || IRemoteCommandShellService.class.equals(service)) {
                return (T)remoteConnection.getService(TelnetConnection.class);
            }
            return null;
        }
    }
}

