/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.condition;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.condition.ShellMatchingMatcherIsActive;
import org.eclipse.reddeer.core.lookup.ShellLookup;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.util.InstanceValidator;
import org.eclipse.swt.widgets.Shell;
import org.hamcrest.Matcher;

public class ShellIsActive
extends ShellMatchingMatcherIsActive {
    private org.eclipse.reddeer.swt.api.Shell shell;
    private static final Logger log = Logger.getLogger(ShellIsActive.class);

    public ShellIsActive(org.eclipse.reddeer.swt.api.Shell shell) {
        super(new Matcher[0]);
        InstanceValidator.checkNotNull((Object)shell, (String)"shell");
        this.shell = shell;
    }

    public ShellIsActive(Matcher<?> ... matchers) {
        super(matchers);
    }

    public ShellIsActive(String shellText) {
        super(new Matcher[]{new WithTextMatcher(shellText)});
    }

    public boolean test() {
        if (this.shell != null) {
            Shell currentActiveShell = ShellLookup.getInstance().getCurrentActiveShell();
            if (currentActiveShell == null) {
                log.debug("Current active shell is null");
                return false;
            }
            return currentActiveShell.equals(this.shell.getSWTWidget());
        }
        return super.test();
    }

    public String description() {
        if (this.shell != null) {
            return "shell is active";
        }
        return super.description();
    }
}

